/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.test.assertion.raml;

import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.mule.connectors.commons.rest.builder.request.Request;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Form;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlRequestAdapter
implements RamlRequest {
    private static final Logger logger = LoggerFactory.getLogger(RamlRequestAdapter.class);
    private final Request request;

    public RamlRequestAdapter(Request request) {
        this.request = request;
    }

    public String getRequestUrl(String baseUri, boolean includeServletPath) {
        String path = this.request.getPath();
        for (Map.Entry pathParam : this.request.getPathParams().entrySet()) {
            path = path.replace(String.format("${%s}", pathParam.getKey()), ((String)Optional.fromNullable(pathParam.getValue()).or((Object)"")).toString());
        }
        return path;
    }

    public String getMethod() {
        return String.format("%s", this.request.getMethod());
    }

    public Values getQueryValues() {
        return this.toValues(this.request.getQueryParams());
    }

    public Values getFormValues() {
        try {
            Values result = new Values();
            for (Map.Entry entry : ((Form)Form.class.cast(this.request.getEntity())).asMap().entrySet()) {
                result.addValues((String)entry.getKey(), (Iterable)entry.getValue());
            }
            return result;
        }
        catch (ClassCastException e) {
            logger.trace("The request body does not contain a form.", (Throwable)e);
            return new Values();
        }
    }

    public Values getHeaderValues() {
        return this.toValues(this.request.getHeaders());
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public byte[] getContent() {
        return ((String)Optional.fromNullable((Object)this.request.getEntity()).transform(Functions.toStringFunction()).or((Object)"")).getBytes(Charset.forName("UTF-8"));
    }

    private Values toValues(Map<String, String> params) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.put(entry.getKey(), new String[]{entry.getValue()});
        }
        return new Values(result);
    }
}

