/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.test.assertion.raml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.mule.connectors.commons.rest.test.assertion.RequestAndResponse;
import com.mule.connectors.commons.rest.test.assertion.RequestAndResponseAssertion;
import com.mule.connectors.commons.rest.test.assertion.raml.RamlRequestAdapter;
import com.mule.connectors.commons.rest.test.assertion.raml.RamlResponseAdapter;
import guru.nidi.ramltester.RamlDefinition;
import guru.nidi.ramltester.RamlLoaders;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.Validation;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.RamlResponse;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class ValidRaml
extends BaseMatcher<RequestAndResponse>
implements RequestAndResponseAssertion {
    private final RamlDefinition ramlDefinition;
    private final List<Validation> ramlValidations;

    @JsonCreator
    public ValidRaml(@JsonProperty(value="file", required=true) String ramlFilePath, @JsonProperty(value="validations", required=false) List<String> validations) {
        this.ramlDefinition = RamlLoaders.fromClasspath(this.getClass()).load(String.format("classpath://%s", ramlFilePath));
        this.ramlValidations = new ArrayList<Validation>();
        for (String validation : validations == null || validations.isEmpty() ? Lists.newArrayList((Object[])new Validation[]{Validation.URI_PARAMETER, Validation.EXAMPLE, Validation.EMPTY, Validation.PARAMETER}) : validations) {
            this.ramlValidations.add(Validation.valueOf((String)validation.toString()));
        }
    }

    public boolean matches(Object item) {
        return this.getReport(item).isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText("RAML validation");
    }

    public void describeMismatch(Object item, Description description) {
        RamlReport report = this.getReport(item);
        description.appendText("found the following errors:");
        this.addErrors(description, report.getRequestViolations());
        this.addErrors(description, report.getResponseViolations());
        this.addErrors(description, report.getValidationViolations());
    }

    private void addErrors(Description description, RamlViolations errors) {
        for (String error : errors) {
            description.appendText("\n\t\t");
            description.appendText(error);
        }
    }

    private RamlReport getReport(Object item) {
        RequestAndResponse requestAndResponse = (RequestAndResponse)RequestAndResponse.class.cast(item);
        return this.ramlDefinition.testAgainst((RamlRequest)new RamlRequestAdapter(requestAndResponse.getRequest()), (RamlResponse)new RamlResponseAdapter(requestAndResponse.getResponse()));
    }
}

