/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.test.provider;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.mule.connectors.commons.rest.test.exception.InvalidTestCaseFormatException;
import com.mule.connectors.commons.rest.test.exception.UnexpectedParsingException;
import com.mule.connectors.commons.rest.test.provider.TestCase;
import java.io.File;
import java.io.IOException;
import javax.ws.rs.client.Client;

public class FileToCaseTransformer
implements Function<File, Object[]> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Client client;
    private final String baseDirectory;

    public FileToCaseTransformer(File baseDirectory, Client client) {
        this.client = client;
        this.baseDirectory = baseDirectory.getAbsolutePath();
    }

    public Object[] apply(File file) {
        try {
            return new Object[]{file.getAbsolutePath().replace(this.baseDirectory, ""), this.objectMapper.readValue(file, TestCase.class), this.client};
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new InvalidTestCaseFormatException(file, (JsonProcessingException)e);
        }
        catch (IOException e) {
            throw new UnexpectedParsingException(file, e);
        }
    }
}

