/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.test.provider;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.mule.connectors.commons.rest.test.config.TestCasesConfig;
import com.mule.connectors.commons.rest.test.exception.TestCasesDirectoryNotFoundException;
import com.mule.connectors.commons.rest.test.provider.DirectoryFilter;
import com.mule.connectors.commons.rest.test.provider.FileToCaseTransformer;
import com.mule.connectors.commons.rest.test.provider.TestCaseFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.filter.LoggingFilter;

public class TestCasesProvider {
    private final TestCasesConfig config;
    private final FileToCaseTransformer transformationStrategy;

    public TestCasesProvider(TestCasesConfig config) {
        this.config = config;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register((Object)new LoggingFilter(Logger.getLogger(this.getClass().getSimpleName()), true));
        this.transformationStrategy = new FileToCaseTransformer(config.getTestCasesDirectory(), ClientBuilder.newClient((Configuration)clientConfig));
    }

    public List<Object[]> getCases() {
        File testCasesDirectory = this.config.getTestCasesDirectory();
        if (testCasesDirectory.exists() && testCasesDirectory.isDirectory()) {
            return Lists.transform(this.getCaseFiles(testCasesDirectory), (Function)this.transformationStrategy);
        }
        throw new TestCasesDirectoryNotFoundException(testCasesDirectory.getAbsolutePath());
    }

    private List<File> getCaseFiles(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        for (File subDirectory : this.filter(directory, new DirectoryFilter())) {
            files.addAll(this.getCaseFiles(subDirectory));
        }
        files.addAll(Arrays.asList(this.filter(directory, new TestCaseFileFilter())));
        return files;
    }

    private File[] filter(File directory, FileFilter filter) {
        return (File[])Optional.fromNullable((Object)directory.listFiles(filter)).or((Object)new File[0]);
    }
}

