/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.test.assertion.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mule.connectors.commons.rest.test.assertion.RequestAndResponse;
import com.mule.connectors.commons.rest.test.assertion.RequestAndResponseAssertion;
import com.mule.connectors.commons.rest.test.exception.StatusCodeDefinitionException;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class Status
extends BaseMatcher<RequestAndResponse>
implements RequestAndResponseAssertion {
    private static final Pattern PATTERN = Pattern.compile("\\d[\\dxX]{2}");
    private final String expectedValue;
    private final Matcher<String> matcher;

    @JsonCreator
    public Status(@JsonProperty(value="expectedValue", required=true) String expectedValue) {
        if (!PATTERN.matcher(expectedValue).matches()) {
            throw new StatusCodeDefinitionException(expectedValue);
        }
        this.expectedValue = expectedValue;
        this.matcher = CoreMatchers.startsWith((String)expectedValue.toLowerCase().replace("x", ""));
    }

    public boolean matches(Object item) {
        return this.matcher.matches((Object)Integer.toString(this.getResponse(item).getStatus()));
    }

    public void describeTo(Description description) {
        description.appendText("Response status matching ").appendValue((Object)this.expectedValue);
    }

    public void describeMismatch(Object item, Description description) {
        super.describeMismatch((Object)this.getResponse(item).getStatus(), description);
    }

    private Response getResponse(Object item) {
        return ((RequestAndResponse)RequestAndResponse.class.cast(item)).getResponse();
    }
}

