/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.test.provider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.mule.connectors.commons.rest.builder.request.Request;
import com.mule.connectors.commons.rest.test.assertion.RequestAndResponse;
import com.mule.connectors.commons.rest.test.assertion.RequestAndResponseAssertion;
import com.mule.connectors.commons.rest.test.assertion.status.Status;
import com.mule.connectors.commons.rest.test.provider.request.ParameterizedRequest;
import com.mule.connectors.commons.rest.test.provider.request.ResponseTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class TestCase {
    private static final Status STATUS_MATCHER = new Status("2xx");
    private final ParameterizedRequest request;
    private final List<RequestAndResponseAssertion> assertions;
    private final List<ParameterizedRequest> setupAbstractRequestList;
    private final List<ParameterizedRequest> tearDownRequestList;

    @JsonCreator
    public TestCase(@JsonProperty(value="before", required=true) List<ParameterizedRequest> setupAbstractRequestList, @JsonProperty(value="request", required=true) ParameterizedRequest request, @JsonProperty(value="after", required=true) List<ParameterizedRequest> tearDownRequestList, @JsonProperty(value="assertions", required=true) List<RequestAndResponseAssertion> assertions) {
        this.setupAbstractRequestList = (List)Optional.fromNullable(setupAbstractRequestList).or(Collections.emptyList());
        this.request = request;
        this.tearDownRequestList = (List)Optional.fromNullable(tearDownRequestList).or(Collections.emptyList());
        this.assertions = (List)Optional.fromNullable(assertions).or(Collections.emptyList());
    }

    public void execute(Client client) {
        Map<String, String> placeholderStore = new HashMap<String, String>();
        for (ParameterizedRequest setupRequest : this.setupAbstractRequestList) {
            placeholderStore = this.execute(setupRequest, placeholderStore, client, STATUS_MATCHER);
        }
        ArrayList<RequestAndResponseAssertion> matchers = new ArrayList<RequestAndResponseAssertion>();
        matchers.addAll(this.assertions);
        placeholderStore = this.execute(this.request, placeholderStore, client, (Matcher<? super RequestAndResponse>)CoreMatchers.allOf(matchers));
        for (ParameterizedRequest tearDownRequest : this.tearDownRequestList) {
            placeholderStore = this.execute(tearDownRequest, placeholderStore, client, STATUS_MATCHER);
        }
    }

    private Map<String, String> execute(ParameterizedRequest request, Map<String, String> placeholderStore, Client client, Matcher<? super RequestAndResponse> matcher) {
        request.addPlaceHolders(placeholderStore);
        Response response = request.execute(client);
        MatcherAssert.assertThat((Object)new RequestAndResponse((Request)request, response), matcher);
        HashMap<String, String> result = new HashMap<String, String>(placeholderStore);
        String parsedResponse = (String)response.readEntity(String.class);
        for (ResponseTarget responseTarget : request.getResponseTargets()) {
            result.put(responseTarget.getKey(), (String)Optional.fromNullable((Object)responseTarget.match(parsedResponse)).or((Object)""));
        }
        return result;
    }
}

