/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.test.provider.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.mule.connectors.commons.rest.builder.request.Method;
import com.mule.connectors.commons.rest.builder.request.SimpleRequest;
import com.mule.connectors.commons.rest.test.provider.request.ResponseTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class ParameterizedRequest
extends SimpleRequest {
    private Map<String, String> placeholderStore = new HashMap<String, String>();
    private List<ResponseTarget> responseTargets = new ArrayList<ResponseTarget>();

    @JsonCreator
    public ParameterizedRequest(@JsonProperty(value="method") Method behavior) {
        super(behavior);
    }

    @JsonProperty(value="responseTargets")
    public List<ResponseTarget> getResponseTargets() {
        return this.responseTargets;
    }

    public void setResponseTargets(List<ResponseTarget> responseTargets) {
        this.responseTargets = responseTargets;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.resolvePlaceholders(super.getPath());
    }

    @JsonProperty(value="headers")
    public Map<String, String> getHeaders() {
        return this.resolvePlaceholders(super.getHeaders());
    }

    @JsonProperty(value="queryParams")
    public Map<String, String> getQueryParams() {
        return this.resolvePlaceholders(super.getQueryParams());
    }

    @JsonProperty(value="pathParams")
    public Map<String, String> getPathParams() {
        return this.resolvePlaceholders(super.getPathParams());
    }

    @JsonProperty(value="body")
    public Object getEntity() {
        return (this.getContentType().equals("application/x-www-form-urlencoded") || this.getContentType().equals("multipart/form-data")) && Optional.fromNullable((Object)super.getEntity()).isPresent() ? new Form((MultivaluedMap)new MultivaluedHashMap((Map)((LinkedHashMap)super.getEntity()))) : new Form();
    }

    @JsonProperty(value="contentType")
    public String getContentType() {
        return super.getContentType();
    }

    @JsonProperty(value="accept")
    public String getAccept() {
        return super.getAccept();
    }

    public void addPlaceHolders(Map<String, String> placeholderStore) {
        this.placeholderStore.putAll(placeholderStore);
    }

    private <T> Map<String, String> resolvePlaceholders(Map<String, T> input) {
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, T> entry : input.entrySet()) {
            output.put(entry.getKey(), this.resolvePlaceholders(entry.getValue().toString()));
        }
        return output;
    }

    private String resolvePlaceholders(String input) {
        String output = input;
        for (Map.Entry<String, String> entry : this.placeholderStore.entrySet()) {
            output = output.replace(String.format("${%s}", entry.getKey()), entry.getValue());
        }
        return output;
    }
}

