/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.test.assertion.header;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mule.connectors.commons.rest.test.assertion.header.ResponseHeaderAssertion;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class HeaderEquals
extends ResponseHeaderAssertion {
    private final String expectedKey;
    private final String expectedValue;
    private final Matcher<Iterable<? super String>> keyMatcher;
    private final Matcher<Iterable<? super String>> valueMatcher;

    @JsonCreator
    public HeaderEquals(@JsonProperty(value="expectedKey", required=true) String expectedKey, @JsonProperty(value="expectedValue", required=true) String expectedValue) {
        this.expectedKey = expectedKey;
        this.expectedValue = expectedValue;
        this.keyMatcher = CoreMatchers.hasItem((Object)expectedKey);
        this.valueMatcher = CoreMatchers.hasItem((Object)expectedValue);
    }

    @Override
    public boolean matches(Map<String, List<Object>> headers) {
        return this.keyMatcher.matches(headers.keySet()) && this.valueMatcher.matches(headers.get(this.expectedKey));
    }

    public void describeTo(Description description) {
        description.appendText("Header ").appendValue((Object)this.expectedKey).appendText(" equals ").appendValue((Object)this.expectedValue);
    }

    public void describeMismatch(Object item, Description description) {
        description.appendText("Header ").appendValue((Object)this.expectedKey).appendText(" with value ").appendValue((Object)this.expectedValue).appendText(" not found.");
    }
}

