/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.builder.handler;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.mule.connectors.commons.rest.builder.handler.ResponseHandler;
import com.mule.connectors.commons.rest.builder.handler.ResponseStatusExceptionMapper;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResponseHandler<T>
implements ResponseHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResponseHandler.class);

    @Override
    public T handleResponse(final Response response, Type responseType) {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        Response.Status.Family family = response.getStatusInfo().getFamily();
        logger.debug("Response Status is {}", (Object)status);
        logger.trace("Response body:\n{}", response.readEntity(String.class));
        if (Response.Status.Family.SUCCESSFUL != family) {
            WebApplicationException exception = null;
            try {
                exception = ResponseStatusExceptionMapper.valueOf(((Enum)Optional.fromNullable((Object)status).or((Object)family)).name()).createException(response);
            }
            catch (IllegalArgumentException unmappedStatusException) {
                try {
                    logger.warn("The response status is not mapped.", (Throwable)unmappedStatusException);
                    exception = ResponseStatusExceptionMapper.valueOf(family.name()).createException(response);
                }
                catch (IllegalArgumentException unmappedFamilyException) {
                    exception = new WebApplicationException((Throwable)unmappedFamilyException, response);
                }
            }
            throw exception;
        }
        return (T)Optional.fromNullable((Object)responseType).transform(new Function<Type, T>(){

            public T apply(Type input) {
                logger.debug("Parsing response to an instance of {}", (Object)input);
                return response.readEntity(new GenericType(input));
            }
        }).orNull();
    }
}

