/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.builder;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.mule.connectors.commons.rest.builder.handler.DefaultResponseHandler;
import com.mule.connectors.commons.rest.builder.handler.ResponseHandler;
import com.mule.connectors.commons.rest.builder.listener.RequestListener;
import com.mule.connectors.commons.rest.builder.request.Method;
import com.mule.connectors.commons.rest.builder.request.SimpleRequest;
import com.mule.connectors.commons.rest.builder.util.SimpleParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBuilder<T> {
    private static final Logger logger = LoggerFactory.getLogger(RequestBuilder.class);
    private final Client client;
    private final SimpleRequest request;
    private Type responseType;
    private ResponseHandler<T> responseHandler = new DefaultResponseHandler();
    private List<RequestListener> requestListeners = new ArrayList<RequestListener>();

    private RequestBuilder(Client client, SimpleRequest request, String path) {
        this.client = client;
        this.request = request;
        this.request.setPath(path);
    }

    public RequestBuilder<T> responseType(Type rawType, Type ... parameterTypes) {
        this.responseType = new SimpleParameterizedType(rawType, parameterTypes);
        return this;
    }

    public RequestBuilder<T> responseHandler(ResponseHandler<T> responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public RequestBuilder<T> header(String key, Object value) {
        if (Optional.fromNullable((Object)value).isPresent() && !value.toString().isEmpty()) {
            this.request.addHeader(key, value.toString());
        }
        return this;
    }

    public RequestBuilder<T> basicAuthorization(String username, String password) {
        return this.header("Authorization", String.format("Basic %s", DatatypeConverter.printBase64Binary((byte[])String.format("%s:%s", username, password).getBytes(Charset.forName("UTF-8")))));
    }

    public RequestBuilder<T> queryParam(String key, Object value) {
        if (Optional.fromNullable((Object)value).isPresent() && !Strings.nullToEmpty((String)value.toString()).isEmpty()) {
            this.request.addQueryParam(key, value.toString());
        }
        return this;
    }

    public RequestBuilder<T> queryParams(MultivaluedMap<String, String> queryParams) {
        for (Map.Entry entry : queryParams.entrySet()) {
            this.queryParam((String)entry.getKey(), entry.getValue() == null || ((List)entry.getValue()).isEmpty() ? null : (String)((List)entry.getValue()).get(0));
        }
        return this;
    }

    public RequestBuilder<T> pathParam(String key, Object value) {
        if (Optional.fromNullable((Object)value).isPresent() && !Strings.nullToEmpty((String)value.toString()).isEmpty()) {
            this.request.addPathParam(key, value.toString());
        }
        return this;
    }

    public RequestBuilder<T> entity(Object entity) {
        this.request.setEntity(entity);
        return this;
    }

    public RequestBuilder<T> accept(String accept) {
        this.request.setAccept(accept);
        return this;
    }

    public RequestBuilder<T> contentType(String contentType) {
        this.request.setContentType(contentType);
        return this;
    }

    public RequestBuilder<T> onBeforeRequest(RequestListener ... listeners) {
        this.requestListeners.addAll(Arrays.asList(listeners));
        return this;
    }

    public T execute() {
        for (RequestListener listener : this.requestListeners) {
            logger.debug("Request Listener {} found. Providing request.", listener.getClass());
            listener.handle(this.request);
        }
        Response response = this.request.execute(this.client);
        logger.debug("Parsing response.");
        return this.responseHandler.handleResponse(response, this.responseType);
    }

    public static <T> RequestBuilder<T> get(Client client, String path) {
        return new RequestBuilder<T>(client, new SimpleRequest(Method.GET), path);
    }

    public static <T> RequestBuilder<T> post(Client client, String path) {
        return new RequestBuilder<T>(client, new SimpleRequest(Method.POST), path);
    }

    public static <T> RequestBuilder<T> put(Client client, String path) {
        return new RequestBuilder<T>(client, new SimpleRequest(Method.PUT), path);
    }

    public static <T> RequestBuilder<T> delete(Client client, String path) {
        return new RequestBuilder<T>(client, new SimpleRequest(Method.DELETE), path);
    }
}

