/**
 * Copyright (c) MuleSoft, Inc. All rights reserved. http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.md file.
 */
package com.mule.connectors.testdata.model;

import static com.mule.connectors.testdata.utils.Utils.transformCamelCaseToXmlName;

public class ConnectorProcessorInfo {
	private String processorName;
	private String processorXmlName;

    private String inputDataMapperType = "";
    private String ouputDataMapperType = "";

    private Boolean hasQuerySupport = false;
    private Boolean hasAutoPaging = false;

    public ConnectorProcessorInfo(){}

	public ConnectorProcessorInfo(String operationName) {
		processorName = operationName;
		processorXmlName = transformCamelCaseToXmlName(operationName);
	}

	public String getProcessorName() {
		return processorName;
	}

	public void setProcessorName(String processorName) {
		this.processorName = processorName;
		processorXmlName = transformCamelCaseToXmlName(processorName);
	}

	public String getProcessorXmlName() {
		return processorXmlName;
	}

    public Boolean hasQuerySupport() {
        return hasQuerySupport;
    }

    public void setQuerySupport(boolean hasQuerySupport) {
        this.hasQuerySupport = hasQuerySupport;
    }

    public Boolean hasAutoPaging() { return hasAutoPaging; }

    public void setAutoPaging(boolean hasAutoPaging) {
        this.hasAutoPaging = hasAutoPaging;
    }

    public String getInputDataMapperType() {
        return inputDataMapperType;
    }

    public void setInputDataMapperType(String inputDataMapperType) {
        this.inputDataMapperType = inputDataMapperType;
    }

    public String getOuputDataMapperType() {
        return ouputDataMapperType;
    }

    public void setOutputDataMapperType(String ouputDataMapperType) {
        this.ouputDataMapperType = ouputDataMapperType;
    }
}
