/**
 * Copyright (c) MuleSoft, Inc. All rights reserved. http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.md file.
 */
package com.mule.connectors.testdata.model;

import java.util.LinkedList;
import java.util.List;

public class ConnectorProperties {



    public enum MetadataType {STATIC, DYNAMIC, NONE};

    private List<ConnectorProcessorInfo> connectorProcessorsInfo;

    private String name = "";
    private Boolean hasConnectivitySupport = true;
    private Boolean hasOAuthAuthentication = false;
    private MetadataType metadataType = MetadataType.STATIC;

	public ConnectorProperties() {
		super();
		connectorProcessorsInfo = new LinkedList<ConnectorProcessorInfo>();
	}

	public List<ConnectorProcessorInfo> getConnectorProcessorsInfo() {
		return connectorProcessorsInfo;
	}
	
	public void addConnectorOperationInfo(ConnectorProcessorInfo connectorOperationInfo) {
		if (connectorOperationInfo != null) {
			connectorProcessorsInfo.add(connectorOperationInfo);
		}
	}

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean hasOAuthAuthentication() {
        return hasOAuthAuthentication;
    }

    public void setOAuthAuthentication(boolean hasOAuthAuthentication) {
        this.hasOAuthAuthentication = hasOAuthAuthentication;
    }

    public Boolean hasConnectivitySupport() {
        return hasConnectivitySupport;
    }

    public void setConnectivitySupport(boolean hasConnectivitySupport) {
        this.hasConnectivitySupport = hasConnectivitySupport;
    }

    public Boolean hasDatasenseEnabled() {
        return (metadataType != MetadataType.NONE);
    }

    public MetadataType getMetadataType() {
        return metadataType;
    }

    public void setMetadataType(MetadataType metadataType) {
        this.metadataType = metadataType;
    }

    public void setMetadataType(String metadataTypeName) {

        if(metadataTypeName.toLowerCase().equals(MetadataType.DYNAMIC.name().toLowerCase())){
            this.metadataType = MetadataType.DYNAMIC;

        } else if(metadataTypeName.toLowerCase().equals(MetadataType.STATIC.name().toLowerCase())){
            this.metadataType = MetadataType.STATIC;

        } else {
            this.metadataType = MetadataType.NONE;
        }
    }


}
