package com.mule.connectors.testdata.parsers;

import com.mule.connectors.testdata.model.ConnectorProperties;
import com.mule.connectors.testdata.model.ConnectorProcessorInfo;
import com.mule.connectors.testdata.model.naming.PropertiesTagNames;
import com.mule.connectors.testdata.model.naming.GeneralAttributes;
import com.mule.connectors.testdata.model.naming.OutputTagNames;
import com.mule.connectors.testdata.utils.DocumentHandler;
import com.mule.connectors.testdata.utils.XPathEvaluator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AnnotationsXmlParser {

    /**
     * Input xml file containing the connector and processors properties.
     */
    private String inputFile = "";


    /**
     *  Document instance of the input file
     * */
    private DocumentHandler sourceDoc = null;


    /**
     *  Lookup table for processors info.
     */
    private Map<String, ConnectorProcessorInfo> processorsInfo = new HashMap<String, ConnectorProcessorInfo>();

    /**
     *  Information retrieved of the current connector
     * */
    private ConnectorProperties connectorInfo = new ConnectorProperties();


    private XPathEvaluator xPathEvaluator;


    public AnnotationsXmlParser(String inputFile)
            throws IOException, SAXException, ParserConfigurationException
    {
        this.inputFile = inputFile;
        this.sourceDoc = new DocumentHandler(inputFile);

        this.xPathEvaluator = new XPathEvaluator(this.sourceDoc.getDoc());
    }

    public Element getPropertiesNode(){
        return xPathEvaluator.getFirstElementWithTag(OutputTagNames.PROPERTIES);
    }


    public ConnectorProperties retrieveConnectorProperties()
            throws XPathExpressionException
    {

        Element properties = xPathEvaluator.getFirstElementWithTag(OutputTagNames.PROPERTIES);

        Element connectivityProp = xPathEvaluator.getFirstElementWithTag(
                                        properties, PropertiesTagNames.CONNECTIVITY_SUPPORT);
        connectorInfo.setConnectivitySupport(Boolean.valueOf(connectivityProp.getTextContent()));


        Element oauthProp = xPathEvaluator.getFirstElementWithTag(
                                properties, PropertiesTagNames.AUTHENTICATION_OAUTH);
        connectorInfo.setOAuthAuthentication(Boolean.valueOf(oauthProp.getTextContent()));


        Element metadataProp = xPathEvaluator.getFirstElementWithTag(
                                    properties, PropertiesTagNames.METADATA_TYPE);
        connectorInfo.setMetadataType(metadataProp.getTextContent());


        return this.connectorInfo;

    }


    public Map<String, ConnectorProcessorInfo> retrieveProcessorsProperties()
            throws XPathExpressionException
    {

        Element msgProcessors = xPathEvaluator.getFirstElementWithTag(OutputTagNames.MESSAGE_PROCESSORS_NODE);

        NodeList processors = xPathEvaluator.evaluateOnElementAndGetNodeList(msgProcessors, "./*");

        for(int indx=0; indx < processors.getLength(); indx++){

            ConnectorProcessorInfo procInfo = new ConnectorProcessorInfo();

            Element eProcessor = (Element) processors.item(indx);

            Element datamapper = xPathEvaluator.getFirstElementWithTag(
                                    eProcessor, OutputTagNames.DATAMAPPER_NODE);

            procInfo.setOutputDataMapperType(datamapper.getAttribute(GeneralAttributes.DM_OUTPUT));
            procInfo.setInputDataMapperType(datamapper.getAttribute(GeneralAttributes.DM_INPUT));

            Element autoPag = xPathEvaluator.getFirstElementWithTag(
                                eProcessor, PropertiesTagNames.AUTO_PAGING);
            procInfo.setAutoPaging(Boolean.valueOf(autoPag.getTextContent()));

            Element querySupport = xPathEvaluator.getFirstElementWithTag(
                                      eProcessor, PropertiesTagNames.QUERY_SUPPORT);
            procInfo.setQuerySupport(Boolean.valueOf(querySupport.getTextContent()));


            this.processorsInfo.put(eProcessor.getTagName(), procInfo);
        }

        return this.processorsInfo;
    }

}
