package com.mule.connectors.testdata.templates;

import com.mule.connectors.testdata.model.naming.GeneralAttributes;
import com.mule.connectors.testdata.model.naming.OutputTagNames;
import com.mule.connectors.testdata.utils.DocumentHandler;
import com.mule.connectors.testdata.utils.Utils;
import org.apache.commons.lang.WordUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class AutomationBeansTemplate {

    private DocumentHandler beansDoc = null;
    private Element beansRoot = null;

    public AutomationBeansTemplate() throws ParserConfigurationException {

        beansDoc = new DocumentHandler();

        beansRoot = beansDoc.createRootElement("beans");
        beansRoot.setAttribute("xmlns","http://www.springframework.org/schema/beans");
        beansRoot.setAttribute("xmlns:xsi","http://www.w3.org/2001/XMLSchema-instance");
        beansRoot.setAttribute("xmlns:util","http://www.springframework.org/schema/util");
        beansRoot.setAttribute("xmlns:tx","http://www.springframework.org/schema/tx");
        beansRoot.setAttribute("xmlns:aop", "http://www.springframework.org/schema/aop");
        beansRoot.setAttribute("xsi:schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.5.xsd\n" +
                "http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util-2.5.xsd\n" +
                "http://www.springframework.org/schema/tx http://www.springframework.org/schema/tx/spring-tx-2.5.xsd\n" +
                "http://www.springframework.org/schema/aop http://www.springframework.org/schema/aop/spring-aop-2.5.xsd");


    }

    public void createAutomationBeansFromProcessors(Element messageProcessors)
            throws ParserConfigurationException, TransformerException
    {

        NodeList processorNodes = messageProcessors.getChildNodes();

        for(int i=0; i<processorNodes.getLength(); i++){
            if(processorNodes.item(i).getNodeType() == Node.ELEMENT_NODE){

                Element processor = (Element) processorNodes.item(i);

                StringBuilder nameBuilder = new StringBuilder();

                String testCaseName =  WordUtils.capitalizeFully(Utils.toHumanReadable(processor.getTagName())).replace(" ", "");

                nameBuilder.append("test").append(testCaseName).append("TestData");

                Element utilsMap = beansDoc.createElement("util:map");
                utilsMap.setAttribute("id", nameBuilder.toString());
                utilsMap.setAttribute("map-class", "java.util.HashMap");
                utilsMap.setAttribute("scope", "prototype");
                utilsMap.setAttribute("key-type", "java.lang.String");
                utilsMap.setAttribute("value-type", "java.lang.Object");
                utilsMap.setTextContent("\n ");

                NodeList requiredNodes = processor.getElementsByTagName(OutputTagNames.REQUIRED);
                for(int attrIndx=0; attrIndx<requiredNodes.getLength(); attrIndx++){

                    Element attribute = (Element) requiredNodes.item(attrIndx);

                    Element entry = beansDoc.createElement("entry");
                    entry.setAttribute("key", attribute.getAttribute(GeneralAttributes.NAME));
                    entry.setAttribute("value", ""); //required has no default values

                    utilsMap.appendChild(entry);
                }

                NodeList optionalNodes = processor.getElementsByTagName(OutputTagNames.OPTIONAL);
                for(int attrIndx=0; attrIndx<optionalNodes.getLength(); attrIndx++){

                    Element attribute = (Element) optionalNodes.item(attrIndx);

                    Element entry = beansDoc.createElement("entry");
                    entry.setAttribute("key", attribute.getAttribute(GeneralAttributes.NAME));
                    entry.setAttribute("value", attribute.getAttribute(GeneralAttributes.DEFAULT));

                    utilsMap.appendChild(entry);
                }

                beansRoot.appendChild(utilsMap);
            }

        }
    }

    public void exportToFile() throws TransformerException {

        beansDoc.exportToFile("AutomationSpringBeans.xml");
    }
}
