/**
 * Copyright (c) MuleSoft, Inc. All rights reserved. http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.md file.
 */
package com.mule.connectors.testdata.utils;

import com.mule.connectors.testdata.model.naming.GeneralAttributes;
import org.w3c.dom.Element;

import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic.Kind;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
	
	static final private Pattern camelCaseToMuleXmlPattern = Pattern.compile("([A-Z0-9])");

	static public String transformCamelCaseToXmlName(String camelName) {
		if (camelName == null || camelName.isEmpty()) {
			return null;
		}
		
		Matcher matcher = camelCaseToMuleXmlPattern.matcher(camelName);
		StringBuffer sb = new StringBuffer();		
		
		while (matcher.find()) {
			matcher.appendReplacement(sb, "-" + matcher.group(1).toLowerCase());
		}
		
		matcher.appendTail(sb);
		
		return sb.toString();
	}

    static public String toHumanReadable(String str){

        String name  = str.replaceAll("-", " ");
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    static public void copyFieldPropertiesToAttributeNode(Element attribute, Element field) {

        attribute.setAttribute(GeneralAttributes.TYPE, field.getTagName());
        attribute.setAttribute(GeneralAttributes.CAPTION,field.getAttribute(GeneralAttributes.CAPTION));

        String javaType = field.getAttribute(GeneralAttributes.JAVATYPE);
        javaType = (javaType.equals("") ? "java.lang.String" : javaType);

        attribute.setAttribute(GeneralAttributes.JAVATYPE, javaType);
    }

}
