package com.mule.connectors.testdata.utils;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;


import com.mule.connectors.testdata.utils.UniversalNamespaceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;

public class XPathEvaluator {

    private Document doc;
    private XPath xPathParser =  XPathFactory.newInstance().newXPath();

    public XPathEvaluator(Document sourceDoc){
        this.doc = sourceDoc;
        xPathParser.setNamespaceContext(new UniversalNamespaceResolver(doc));
    }

    /*
    *   Default evaluation is made with the associated document as parent
    * */
    public NodeList evaluateOnDocAndGetNodeList(String expression)
            throws XPathExpressionException
    {
        return (NodeList) xPathParser.compile(expression).evaluate(doc, XPathConstants.NODESET);
    }

    /*
    *   Alternative evaluation, made with an Element as parent
    * */
    public NodeList evaluateOnElementAndGetNodeList(Element elem, String expression) throws XPathExpressionException {

        return (NodeList) xPathParser.compile(expression).evaluate(elem, XPathConstants.NODESET);
    }


    public Node evaluateOnElementAndGetNode(Element elem, String expression) throws XPathExpressionException {

        return (Node) xPathParser.compile(expression).evaluate(elem, XPathConstants.NODE);
    }

    public boolean hasChildElement(Element parent, String childName){

        NodeList nodes = parent.getChildNodes();
        boolean found = false;
        int i = 0;

        while(!found && i < nodes.getLength()){
            Node current = nodes.item(i);
            found = (current.getNodeName().contains(childName));

            i++;
        }

        return found;
    }


    /**
     *   Searches the whole document and returns the first element
     *  with tag equals to @tag.
     *   If none is found, null is returned
     * */
    public Element getFirstElementWithTag(String tag){

        return this.getFirstElementWithTag(doc.getDocumentElement(), tag);
    }


    /**
     *   Searches from the @parent node and returns the first element
     *  with tag equals to @tag.
     *   If none is found, null is returned
     * */
    public Element getFirstElementWithTag(Element parent, String tag){

        NodeList foundElements = parent.getElementsByTagName(tag);
        if( foundElements.getLength() > 0)
            return (Element) foundElements.item(0);

        return null;
    }


}
