/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata;

import com.mule.connectors.testdata.model.ConnectorProcessorInfo;
import com.mule.connectors.testdata.parsers.AnnotationsXmlParser;
import com.mule.connectors.testdata.parsers.ConnectorSchemaParser;
import com.mule.connectors.testdata.parsers.StudioEditorsXmlParser;
import com.mule.connectors.testdata.templates.AutomationBeansTemplate;
import com.mule.connectors.testdata.templates.PropertiesOverriderTemplate;
import com.mule.connectors.testdata.utils.DocumentHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TestDataParserMojo
extends AbstractMojo {
    private String logLevel;
    private String credentialsFile;
    private String annotationsFile;
    private String outputFile;
    private String targetDir;
    private String outputDir;
    private File schemaFile = null;
    private File editorsFile = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.getLog().isDebugEnabled() || this.logLevel.equals("debug")) {
                Logger.getRootLogger().setLevel(Level.DEBUG);
            }
            this.outputFile = this.outputFile.equals("") ? "output.xml" : this.outputFile;
            this.outputDir = this.outputFile.equals("") ? "./src/test/resources" : this.outputDir;
            DocumentHandler.setOutputPath(this.outputDir);
            this.getLog().info((CharSequence)"=================================================");
            this.getLog().info((CharSequence)"******** Begin Parsing of TestData files ********");
            this.getLog().info((CharSequence)"=================================================");
            this.findEditorsAndSchemaFiles();
            this.getLog().info((CharSequence)"** Parsing Schema file ");
            ConnectorSchemaParser connectorSchemaParser = new ConnectorSchemaParser(this.schemaFile, this.outputFile);
            connectorSchemaParser.parseComplexTypeNodesDefinitions();
            connectorSchemaParser.parseRootElementNodesDefinitions();
            this.getLog().info((CharSequence)"** Parsing Editors file ");
            StudioEditorsXmlParser studioEditorsXmlParser = new StudioEditorsXmlParser(this.editorsFile);
            studioEditorsXmlParser.addStudioAttributePropertiesToProcessors(connectorSchemaParser.getProcessorsElement());
            studioEditorsXmlParser.addStudioAttributePropertiesToGlobalConfig(connectorSchemaParser.getConfigElement());
            this.getLog().info((CharSequence)"** Parsing Annotations Processor output file ");
            AnnotationsXmlParser annotationsXMLParser = new AnnotationsXmlParser(this.annotationsFile);
            Element connectorsPropertiesNode = annotationsXMLParser.getPropertiesNode();
            Map<String, ConnectorProcessorInfo> processorsProperties = annotationsXMLParser.retrieveProcessorsProperties();
            this.getLog().info((CharSequence)"** Creating Overrides template ");
            PropertiesOverriderTemplate overridesTemplate = new PropertiesOverriderTemplate(connectorSchemaParser.getConnectorName(), this.outputFile);
            overridesTemplate.setConfigElement(connectorSchemaParser.getConfigElement(), this.credentialsFile);
            overridesTemplate.setMessageProcessorsElement(connectorSchemaParser.getProcessorsElement(), processorsProperties);
            overridesTemplate.setPropertiesElement(connectorsPropertiesNode);
            this.getLog().info((CharSequence)"** Creating Automation Beans template");
            AutomationBeansTemplate automationBeansTemplate = new AutomationBeansTemplate();
            automationBeansTemplate.createAutomationBeansFromProcessors(connectorSchemaParser.getMessageProcessors());
            this.getLog().info((CharSequence)("** Export Basic Testdata file: " + this.outputFile));
            connectorSchemaParser.exportToFile();
            this.getLog().info((CharSequence)"** Export Overrides Testdata file");
            overridesTemplate.exportToFile();
            this.getLog().info((CharSequence)"** Export Automation Spring Beans");
            automationBeansTemplate.exportToFile();
            this.getLog().info((CharSequence)"=================================================");
            this.getLog().info((CharSequence)"=================================================");
        }
        catch (XPathExpressionException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new RuntimeException(e);
        }
        catch (TransformerConfigurationException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new RuntimeException(e);
        }
    }

    private void findEditorsAndSchemaFiles() {
        this.getLog().debug((CharSequence)("*** Path to META-INF :: " + this.targetDir + "/generated-sources/mule/META-INF"));
        String xsdName = "";
        File metaInf = new File(this.targetDir + "/generated-sources/mule/META-INF");
        for (File temp : metaInf.listFiles()) {
            if (!temp.isFile()) continue;
            this.getLog().debug((CharSequence)("*** File in META :: " + temp.getName()));
            if (!temp.getName().contains(".xsd")) continue;
            xsdName = temp.getName();
            this.schemaFile = temp;
        }
        String editorsDirectory = xsdName.replace("mule-", "").replace(".xsd", "");
        File mule = new File(this.targetDir + "/generated-sources/mule");
        for (File temp : mule.listFiles()) {
            if (!temp.isDirectory() || !temp.getName().equals(editorsDirectory)) continue;
            for (File inner : temp.listFiles()) {
                this.getLog().debug((CharSequence)("*** File in mule :: " + inner.getName()));
                if (!inner.getName().equals("editors.xml")) continue;
                this.editorsFile = inner;
            }
        }
    }
}

