/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata.parsers;

import com.mule.connectors.testdata.model.ConnectorProcessorInfo;
import com.mule.connectors.testdata.model.ConnectorProperties;
import com.mule.connectors.testdata.utils.DocumentHandler;
import com.mule.connectors.testdata.utils.XPathEvaluator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsXmlParser {
    private String inputFile = "";
    private DocumentHandler sourceDoc = null;
    private Map<String, ConnectorProcessorInfo> processorsInfo = new HashMap<String, ConnectorProcessorInfo>();
    private ConnectorProperties connectorInfo = new ConnectorProperties();
    private XPathEvaluator xPathEvaluator;

    public AnnotationsXmlParser(String inputFile) throws IOException, SAXException, ParserConfigurationException {
        this.inputFile = inputFile;
        this.sourceDoc = new DocumentHandler(inputFile);
        this.xPathEvaluator = new XPathEvaluator(this.sourceDoc.getDoc());
    }

    public Element getPropertiesNode() {
        return this.xPathEvaluator.getFirstElementWithTag("properties");
    }

    public ConnectorProperties retrieveConnectorProperties() throws XPathExpressionException {
        Element properties = this.xPathEvaluator.getFirstElementWithTag("properties");
        Element connectivityProp = this.xPathEvaluator.getFirstElementWithTag(properties, "connectivity-support");
        this.connectorInfo.setConnectivitySupport(Boolean.valueOf(connectivityProp.getTextContent()));
        Element oauthProp = this.xPathEvaluator.getFirstElementWithTag(properties, "OAuth-authentication");
        this.connectorInfo.setOAuthAuthentication(Boolean.valueOf(oauthProp.getTextContent()));
        Element metadataProp = this.xPathEvaluator.getFirstElementWithTag(properties, "metadata");
        this.connectorInfo.setMetadataType(metadataProp.getTextContent());
        return this.connectorInfo;
    }

    public Map<String, ConnectorProcessorInfo> retrieveProcessorsProperties() throws XPathExpressionException {
        Element msgProcessors = this.xPathEvaluator.getFirstElementWithTag("message-processors");
        NodeList processors = this.xPathEvaluator.evaluateOnElementAndGetNodeList(msgProcessors, "./*");
        for (int indx = 0; indx < processors.getLength(); ++indx) {
            ConnectorProcessorInfo procInfo = new ConnectorProcessorInfo();
            Element eProcessor = (Element)processors.item(indx);
            Element datamapper = this.xPathEvaluator.getFirstElementWithTag(eProcessor, "datamapper");
            procInfo.setOutputDataMapperType(datamapper.getAttribute("output"));
            procInfo.setInputDataMapperType(datamapper.getAttribute("input"));
            Element autoPag = this.xPathEvaluator.getFirstElementWithTag(eProcessor, "auto-paging");
            procInfo.setAutoPaging(Boolean.valueOf(autoPag.getTextContent()));
            Element querySupport = this.xPathEvaluator.getFirstElementWithTag(eProcessor, "query-support");
            procInfo.setQuerySupport(Boolean.valueOf(querySupport.getTextContent()));
            this.processorsInfo.put(eProcessor.getTagName(), procInfo);
        }
        return this.processorsInfo;
    }
}

