/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata.parsers;

import com.mule.connectors.testdata.utils.DocumentHandler;
import com.mule.connectors.testdata.utils.XPathEvaluator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorSchemaParser {
    private Logger logger = Logger.getLogger(ConnectorSchemaParser.class);
    private final String CACHEDTYPE_ID = "cachedTypeId";
    private DocumentHandler sourceDoc;
    private String outputFile;
    private DocumentHandler outputDoc;
    private Map<String, Element> sourceTypes = new HashMap<String, Element>();
    private Map<String, Map<String, List<Element>>> baseTypesCache = new HashMap<String, Map<String, List<Element>>>();
    private Set<String> configKeys = new HashSet<String>();
    private String connectorName;
    private XPathEvaluator xPathEvaluator;
    private Element configElement = null;
    private Element processorsElement = null;
    private Element inboundEndpointElement = null;
    private Element outboundEndpointElement = null;

    public Element getMessageProcessors() {
        return this.processorsElement;
    }

    public ConnectorSchemaParser(File inputFile, String outputFile) throws IOException, SAXException, ParserConfigurationException {
        this.logger.debug((Object)"- Initialize SchemaParser");
        this.outputFile = outputFile;
        this.logger.debug((Object)("  Reading input file: " + inputFile));
        this.sourceDoc = new DocumentHandler(inputFile);
        this.outputDoc = new DocumentHandler();
        this.xPathEvaluator = new XPathEvaluator(this.sourceDoc.getDoc());
        this.connectorName = inputFile.getCanonicalPath().substring(inputFile.getCanonicalPath().lastIndexOf(47) + 1).replace(".xsd", "").replace("mule-", "");
    }

    public void parseComplexTypeNodesDefinitions() throws XPathExpressionException {
        this.logger.debug((Object)"- Parse complex type definitions");
        String typeElementsXPathExpression = "//xs:complexType";
        NodeList typeNodes = this.xPathEvaluator.evaluateOnDocAndGetNodeList(typeElementsXPathExpression);
        this.logger.debug((Object)"  Retrived nodes");
        this.sourceTypes = this.parseTypeNodesByName(typeNodes);
    }

    public void parseRootElementNodesDefinitions() throws XPathExpressionException {
        this.logger.debug((Object)"- Parse root element definitions");
        Element rootOutElem = this.outputDoc.createRootElement("connector");
        rootOutElem.setAttribute("name", this.connectorName);
        this.configElement = this.outputDoc.createElement("global-config");
        this.inboundEndpointElement = this.outputDoc.createElement("inbound-endpoint");
        this.outboundEndpointElement = this.outputDoc.createElement("outbound-endpoints");
        this.processorsElement = this.outputDoc.createElement("message-processors");
        String sourceElementsXPathExpression = "/xs:schema/xs:element";
        NodeList sourceElements = this.xPathEvaluator.evaluateOnDocAndGetNodeList(sourceElementsXPathExpression);
        for (int i = 0; i < sourceElements.getLength(); ++i) {
            Element sourceElem = (Element)sourceElements.item(i);
            Element outputElem = this.createOutputElementFromDefinition(sourceElem);
            if (outputElem == null) continue;
            this.logger.debug((Object)("-- Create node based on element's type :: " + outputElem.getTagName()));
            if (sourceElem.getAttribute("substitutionGroup").contains("message-processor")) {
                this.logger.debug((Object)("-- Created Processor Element :: " + outputElem.getTagName()));
                this.processorsElement.appendChild(outputElem);
                continue;
            }
            if (sourceElem.getAttribute("substitutionGroup").contains("inbound-endpoint")) {
                this.logger.debug((Object)("-- Created Inbound Endpoint Element :: " + outputElem.getTagName()));
                this.inboundEndpointElement.appendChild(outputElem);
                continue;
            }
            if (sourceElem.getAttribute("substitutionGroup").contains("outbound-endpoints")) {
                this.logger.debug((Object)("-- Created Outbound Endpoint Element :: " + outputElem.getTagName()));
                this.outboundEndpointElement.appendChild(outputElem);
                continue;
            }
            this.configElement.appendChild(outputElem);
        }
        rootOutElem.appendChild(this.configElement);
        rootOutElem.appendChild(this.processorsElement);
        rootOutElem.appendChild(this.inboundEndpointElement);
        rootOutElem.appendChild(this.outboundEndpointElement);
    }

    private void prettyprint(Element e, int indent) {
        NodeList top = e.getChildNodes();
        for (int node = 0; node < top.getLength(); ++node) {
            if (top.item(node).getNodeType() != 1) continue;
            Element inner = (Element)top.item(node);
            String ind = "";
            for (int space = 0; space < indent; ++space) {
                ind = ind + " ";
            }
            this.logger.debug((Object)(ind + "TAG:: " + inner.getTagName() + "   NAME  :: " + inner.getAttribute("name")));
            this.prettyprint(inner, indent + 1);
        }
    }

    public void exportToFile() throws TransformerException {
        this.logger.debug((Object)("- Export file: " + this.outputFile));
        this.outputDoc.exportToFile(this.outputFile);
    }

    private Map<String, List<Element>> parseComplexContent(Element complexContentRoot, boolean avoidDuplicates) throws XPathExpressionException {
        this.logger.debug((Object)("---  Parse complex content Root :: " + complexContentRoot.getTagName()));
        this.logger.debug((Object)("---  Parse complex content ID :: " + complexContentRoot.getAttribute("cachedTypeId")));
        this.logger.debug((Object)"  Retrieve base element nodes");
        Map<String, List<Element>> innerNodes = this.retrieveBaseElementsNodes(complexContentRoot);
        this.logger.debug((Object)"  Get attributes nodes");
        List<Element> attributes = this.getElementAttributes(complexContentRoot, avoidDuplicates);
        innerNodes.get("attributes").addAll(attributes);
        this.logger.debug((Object)"  Get child elements");
        Element sequenceNode = (Element)complexContentRoot.getElementsByTagName("xs:sequence").item(0);
        List<Element> childElements = this.parseChildElements(sequenceNode);
        innerNodes.get("childElements").addAll(childElements);
        return innerNodes;
    }

    private Map<String, List<Element>> retrieveBaseElementsNodes(Element complexContentRoot) throws XPathExpressionException {
        this.logger.debug((Object)"- Retrieve Base Elements Nodes");
        HashMap<String, List<Element>> innerNodes = new HashMap<String, List<Element>>();
        innerNodes.put("attributes", new LinkedList());
        innerNodes.put("childElements", new LinkedList());
        String expression = "./xs:extension";
        NodeList extensionNodes = this.xPathEvaluator.evaluateOnElementAndGetNodeList(complexContentRoot, expression);
        for (int i = 0; i < extensionNodes.getLength(); ++i) {
            Element extensionNode = (Element)extensionNodes.item(i);
            Map<String, List<Element>> inheritedNodes = this.evaluateBase(extensionNode);
            if (inheritedNodes == null) continue;
            this.logger.debug((Object)("-- Obtained from evaluateBase " + inheritedNodes.get("attributes").size() + " attributes"));
            String elementName = this.getParentElementName(extensionNode);
            this.addInheretedNodesToMyInnerNodes(innerNodes, inheritedNodes, elementName);
        }
        this.logger.debug((Object)("-- Obtained " + ((List)innerNodes.get("attributes")).size() + " from inner.ATTRIBUTES_NODE"));
        this.logger.debug((Object)("-- Obtained " + ((List)innerNodes.get("childElements")).size() + " from inner.CHILD_ELEMENTS_NODE"));
        return innerNodes;
    }

    private Map<String, List<Element>> evaluateBase(Element source) throws XPathExpressionException {
        String baseType = source.getAttribute("base");
        this.logger.debug((Object)("- Evaluate Base :: " + baseType));
        this.logger.debug((Object)("- Source Tag :: " + source.getTagName()));
        if (this.baseTypesCache.containsKey(baseType)) {
            this.logger.debug((Object)("-- Return Cached BaseType :: " + baseType));
            return this.baseTypesCache.get(baseType);
        }
        this.logger.debug((Object)"-- Parse New BaseType");
        Map<String, List<Element>> baseNodes = null;
        Element baseComplexNode = this.sourceTypes.get(baseType);
        if (baseComplexNode != null) {
            Element complexContent = this.getComplexContentNode(baseComplexNode);
            if (complexContent != null) {
                this.logger.debug((Object)("---- complexContent Id :: " + complexContent.getAttribute("cachedTypeId")));
            }
            if ((baseNodes = this.parseComplexContent(complexContent, false)) != null) {
                this.logger.debug((Object)("---- Save BaseType :: " + baseType));
                this.baseTypesCache.put(baseType, baseNodes);
            }
        }
        return baseNodes;
    }

    private void addInheretedNodesToMyInnerNodes(Map<String, List<Element>> innerNodes, Map<String, List<Element>> inheritedNodes, String elementName) {
        this.logger.debug((Object)("- Add inhereted nodes TO :: " + elementName));
        this.logger.debug((Object)("-- innerNodes :: " + innerNodes));
        this.logger.debug((Object)("-- inheritedNodes :: " + inheritedNodes));
        this.addInheretedAttributesToInnerNodes(innerNodes, inheritedNodes, elementName);
        this.addInheretedChildsToInnerNodes(innerNodes, inheritedNodes, elementName);
        this.logger.debug((Object)("--- Inner Attributes result :: " + innerNodes.get("attributes").size()));
        this.logger.debug((Object)("--- Inner Childs result :: " + innerNodes.get("childElements").size()));
    }

    private void addInheretedAttributesToInnerNodes(Map<String, List<Element>> innerNodes, Map<String, List<Element>> inheritedNodes, String elementName) {
        this.logger.debug((Object)"-- Add inhereted ATTRIBUTES");
        for (Element inherited : inheritedNodes.get("attributes")) {
            if (inherited.getAttribute("base").equals("")) {
                inherited.setAttribute("base", elementName);
            }
            innerNodes.get("attributes").add(inherited);
            this.logger.debug((Object)("--- Add :: " + inherited.getAttribute("name") + " ::  TO " + elementName));
        }
    }

    private void addInheretedChildsToInnerNodes(Map<String, List<Element>> innerNodes, Map<String, List<Element>> inheritedNodes, String elementName) {
        this.logger.debug((Object)"-- Add inhereted CHILDS");
        for (Element inherited : inheritedNodes.get("childElements")) {
            if (inherited.getAttribute("base").equals("")) {
                inherited.setAttribute("base", elementName);
            }
            innerNodes.get("childElements").add(inherited);
            this.logger.debug((Object)("--- Add :: " + inherited.getAttribute("name") + " ::  TO " + elementName));
        }
    }

    private List<Element> getElementAttributes(Element parent, boolean saveConfigKeys) throws XPathExpressionException {
        this.logger.debug((Object)("- Get Element Attributes :: " + parent.getTagName()));
        LinkedList<Element> attributes = new LinkedList<Element>();
        NodeList attributeElems = parent.getElementsByTagName("xs:attribute");
        this.logger.debug((Object)("-- Has " + attributeElems.getLength() + " Attributes"));
        for (int j = 0; j < attributeElems.getLength(); ++j) {
            Element srcAttr = (Element)attributeElems.item(j);
            Element newAttr = this.createOutputAttributeElement(srcAttr, !saveConfigKeys);
            if (newAttr == null) continue;
            this.logger.debug((Object)("--- Add Attribute :: " + newAttr.getAttribute("name")));
            attributes.add(newAttr);
            if (!saveConfigKeys) continue;
            this.configKeys.add(newAttr.getAttribute("name"));
        }
        return attributes;
    }

    private String getParentElementName(Element attributesRoot) {
        this.logger.debug((Object)"- Get Parent Element Name");
        Element n = (Element)attributesRoot.getParentNode();
        while (!n.getNodeName().equals("xs:element") && !n.getNodeName().equals("xs:schema")) {
            n = (Element)n.getParentNode();
        }
        this.logger.debug((Object)("-- Parent element name :: " + n.getAttribute("name")));
        return n.getAttribute("name");
    }

    private Element createOutputElementFromDefinition(Element sourceElem) throws XPathExpressionException {
        this.logger.debug((Object)("- Create outputElement :: " + sourceElem.getAttribute("name")));
        Element outputElem = this.outputDoc.createElement(sourceElem.getAttribute("name"));
        Element complexContent = this.getComplexContentNode(sourceElem);
        if (complexContent != null) {
            this.logger.debug((Object)("----  outputElement Name :: " + sourceElem.getAttribute("name")));
            boolean avoidDuplicates = sourceElem.getAttribute("name").contains("config");
            Map<String, List<Element>> innerNodes = this.parseComplexContent(complexContent, avoidDuplicates);
            this.appendAttributesFromInnerNodes(outputElem, innerNodes);
            this.appendChildElementsFromInnerNodes(outputElem, innerNodes);
            return outputElem;
        }
        return null;
    }

    private void appendChildElementsFromInnerNodes(Element outputElem, Map<String, List<Element>> innerNodes) {
        if (!innerNodes.get("childElements").isEmpty()) {
            Element childsNode = this.evaluateInnerChildElements(innerNodes);
            outputElem.appendChild(childsNode);
        }
    }

    private void appendAttributesFromInnerNodes(Element outputElem, Map<String, List<Element>> innerNodes) {
        if (!innerNodes.get("attributes").isEmpty()) {
            Element attributesNode = this.outputDoc.createElement("attributes");
            for (Element attr : innerNodes.get("attributes")) {
                Element newAttr = (Element)this.outputDoc.importNode(attr, true);
                attributesNode.appendChild(newAttr);
            }
            outputElem.appendChild(attributesNode);
        }
    }

    private Element createChildElement(Element child) throws XPathExpressionException {
        this.logger.debug((Object)"- Create child Element");
        Element outputElem = this.outputDoc.createElement(this.getCorrespondingTag(child));
        this.logger.debug((Object)("-- Child Element Name :: " + child.getAttribute("name")));
        outputElem.setAttribute("name", child.getAttribute("name"));
        Element complexContent = this.getComplexContentNode(child);
        if (complexContent != null) {
            Map<String, List<Element>> innerNodes = this.parseComplexContent(complexContent, true);
            if (!innerNodes.get("attributes").isEmpty()) {
                this.logger.debug((Object)"--- Child Element Append Inner Attributes");
                Element attributesNode = this.getAttributesOfChildElementFromInnerNodes(innerNodes);
                outputElem.appendChild(attributesNode);
            }
            Element refAttributes = this.createDefinitionByReferenceAttributeFields();
            outputElem.appendChild(refAttributes);
            if (!innerNodes.get("childElements").isEmpty()) {
                this.logger.debug((Object)"--- Child Element Append ChildElements");
                Element childsNode = this.evaluateInnerChildElements(innerNodes);
                outputElem.appendChild(childsNode);
            }
            return outputElem;
        }
        return null;
    }

    private String getCorrespondingTag(Element child) {
        boolean isOptional = child.getAttribute("minOccurs").equals("0");
        return isOptional ? "optional" : "required";
    }

    private Element evaluateInnerChildElements(Map<String, List<Element>> innerNodes) {
        this.logger.debug((Object)"- Append Inner ChildElements");
        Element childsNode = this.outputDoc.createElement("childElements");
        HashSet childElements = new HashSet(innerNodes.get("childElements"));
        for (Element elem : childElements) {
            Element newChild = (Element)this.outputDoc.importNode(elem, true);
            childsNode.appendChild(newChild);
        }
        return childsNode;
    }

    private Element getAttributesOfChildElementFromInnerNodes(Map<String, List<Element>> innerNodes) {
        this.logger.debug((Object)"- Append Inner Attributes");
        Element attributesNode = this.outputDoc.createElement("attributes");
        attributesNode.setAttribute("controlled", "complex");
        for (Element attr : innerNodes.get("attributes")) {
            Element newAttr = (Element)this.outputDoc.importNode(attr, true);
            attributesNode.appendChild(newAttr);
        }
        return attributesNode;
    }

    private Element createDefinitionByReferenceAttributeFields() {
        this.logger.debug((Object)"- Create Definition By ReferenceAttributeFields");
        Element refAttributes = this.outputDoc.createElement("attributes");
        refAttributes.setAttribute("controlled", "useReference");
        Element refValueAttr = this.outputDoc.createElement("required");
        refValueAttr.setAttribute("name", "ref");
        refAttributes.appendChild(refValueAttr);
        return refAttributes;
    }

    private Element getComplexContentNode(Element parent) throws XPathExpressionException {
        String id;
        this.logger.debug((Object)"- Get ComplexContentNode");
        Element node = null;
        String expression = "";
        if (this.xPathEvaluator.hasChildElement(parent, "xs:complexType")) {
            expression = "./xs:complexType/xs:complexContent";
            node = parent;
            id = parent.getAttribute("name");
        } else {
            expression = "./xs:complexContent";
            id = parent.hasAttribute("type") ? parent.getAttribute("type") : parent.getAttribute("name");
            node = this.sourceTypes.get(id);
        }
        if (node != null) {
            Element contentNode = (Element)this.xPathEvaluator.evaluateOnElementAndGetNodeList(node, expression).item(0);
            if (contentNode != null) {
                contentNode.setAttribute("cachedTypeId", id);
                return contentNode;
            }
            node.setAttribute("cachedTypeId", id);
            return node;
        }
        this.logger.debug((Object)("-- No ComplexContent definition for :: " + parent.getAttribute("name")));
        return null;
    }

    private List<Element> parseChildElements(Element sequenceNode) throws XPathExpressionException {
        this.logger.debug((Object)"- Parse ChildElements");
        LinkedList<Element> childElements = new LinkedList<Element>();
        if (sequenceNode != null) {
            this.logger.debug((Object)("-- ParseChildElements ::  " + sequenceNode.getTagName()));
            NodeList childs = sequenceNode.getElementsByTagName("xs:element");
            this.logger.debug((Object)("--- Child Elements :: " + childs.getLength()));
            for (int i = 0; i < childs.getLength(); ++i) {
                Element childElement = this.createChildElement((Element)childs.item(i));
                if (childElement == null) continue;
                childElements.add(childElement);
            }
        }
        return childElements;
    }

    private Element createOutputAttributeElement(Element sourceNode, boolean avoidDuplicates) {
        this.logger.debug((Object)("- Create Output Attribute Element for :: " + sourceNode.getAttribute("name")));
        String use = sourceNode.getAttribute("use");
        String name = sourceNode.getAttribute("name");
        String defaultValue = sourceNode.getAttribute("default");
        if (name.equals("value-ref") || name.equals("config-ref")) {
            return null;
        }
        if (avoidDuplicates && use.equals("optional") && this.configKeys.contains(name)) {
            this.logger.debug((Object)("-- Skipped attribute :: " + name));
            return null;
        }
        use = use.equals("") ? "optional" : use;
        Element attrElem = this.outputDoc.createElement(use);
        attrElem.setAttribute("name", name);
        if (!defaultValue.equals("")) {
            attrElem.setAttribute("default", defaultValue);
        }
        return attrElem;
    }

    private HashMap<String, Element> parseTypeNodesByName(NodeList typeList) {
        this.logger.debug((Object)"- Parse TypeNodes by Name");
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (int i = 0; i < typeList.getLength(); ++i) {
            Element node = (Element)typeList.item(i);
            if (!node.hasAttribute("name")) continue;
            this.logger.debug((Object)("-- Parsed TypeNodes :: " + node.getAttribute("name")));
            map.put(node.getAttribute("name"), node);
        }
        return map;
    }

    public String getConnectorName() {
        return this.outputDoc.getDocumentElement().getAttribute("name");
    }

    public Element getConfigElement() {
        return this.configElement;
    }

    public Element getProcessorsElement() {
        return this.processorsElement;
    }

    public Element getInboundEndpointElement() {
        return this.inboundEndpointElement;
    }

    public Element getOutboundEndpointElement() {
        return this.outboundEndpointElement;
    }
}

