/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata.parsers;

import com.mule.connectors.testdata.utils.DocumentHandler;
import com.mule.connectors.testdata.utils.Utils;
import com.mule.connectors.testdata.utils.XPathEvaluator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudioEditorsXmlParser {
    private Logger logger = Logger.getLogger(StudioEditorsXmlParser.class);
    private XPathEvaluator xPath;
    private DocumentHandler editorsDoc;
    private Map<String, Element> nestedElements = new HashMap<String, Element>();
    private Map<String, Element> attributesIndex = new HashMap<String, Element>();

    public StudioEditorsXmlParser(File editorsFile) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        this.logger.debug((Object)"- Studio Editors XML Parser Initialize");
        this.editorsDoc = new DocumentHandler(editorsFile);
        this.xPath = new XPathEvaluator(this.editorsDoc.getDoc());
        this.logger.debug((Object)"-- Parse nested elements");
        this.parseNestedElementsDefinitionNodes(this.editorsDoc.getDoc());
    }

    private Map<String, Element> parseNestedElementsDefinitionNodes(Document editorsDoc) throws XPathExpressionException {
        this.logger.debug((Object)"- Parse Nested Elements Definition Nodes");
        NodeList nested = ((Element)editorsDoc.getFirstChild()).getElementsByTagName("nested");
        for (int i = 0; i < nested.getLength(); ++i) {
            Element e = (Element)nested.item(i);
            this.nestedElements.put(e.getAttribute("localId"), e);
        }
        return this.nestedElements;
    }

    public void addStudioAttributePropertiesToProcessors(Element processorsElementFromSchema) throws XPathExpressionException {
        this.logger.debug((Object)"- Add Studio Attribute Properties To Processors");
        NodeList connectorElements = this.editorsDoc.getDocumentElement().getElementsByTagName("cloud-connector");
        this.logger.debug((Object)("-- Found " + connectorElements.getLength() + " Connectors"));
        for (int i = 0; i < connectorElements.getLength(); ++i) {
            Element cloudElem = (Element)connectorElements.item(i);
            String processorName = cloudElem.getAttribute("localId");
            this.logger.debug((Object)("-- Parsing " + processorName + " processor"));
            Element processor = this.xPath.getFirstElementWithTag(processorsElementFromSchema, processorName);
            Element attributeCategory = this.xPath.getFirstElementWithTag(cloudElem, "attribute-category");
            if (processor == null || attributeCategory == null) continue;
            this.addStudioPropertiesToProcessorAttributes(processor, attributeCategory);
            this.parseProcessorChildElement(processor, attributeCategory);
        }
    }

    private void addStudioPropertiesToProcessorAttributes(Element processor, Element attributeCategory) throws XPathExpressionException {
        this.logger.debug((Object)"- Add Studio Properties To Processors Attributes");
        NodeList processorAttributes = this.xPath.evaluateOnElementAndGetNodeList(processor, "./attributes/*");
        this.logger.debug((Object)("-- Found " + processorAttributes.getLength() + " processorAttributes"));
        for (int p = 0; p < processorAttributes.getLength(); ++p) {
            Element attribute = (Element)processorAttributes.item(p);
            String name = attribute.getAttribute("name");
            if (this.isConfigAttribute(name)) continue;
            String expression = "./*/*[@name='" + name + "']";
            Element field = (Element)this.xPath.evaluateOnElementAndGetNode(attributeCategory, expression);
            if (field != null) {
                Utils.copyFieldPropertiesToAttributeNode(attribute, field);
                Element group = (Element)field.getParentNode();
                attribute.setAttribute("group", group.getAttribute("caption"));
                continue;
            }
            Element parent = (Element)attribute.getParentNode();
            parent.removeChild(attribute);
        }
    }

    private boolean isConfigAttribute(String name) {
        return name.equals("config-ref");
    }

    private void parseProcessorChildElement(Element processor, Element attributeCategory) throws XPathExpressionException {
        this.logger.debug((Object)"- Parse Processor Child Element");
        NodeList processorChildElements = this.xPath.evaluateOnElementAndGetNodeList(processor, "./childElements/*");
        this.logger.debug((Object)("-- Found " + processorChildElements.getLength() + " processorChildElements"));
        NodeList childs = this.xPath.evaluateOnElementAndGetNodeList(attributeCategory, "./*/*");
        for (int p = 0; p < processorChildElements.getLength(); ++p) {
            Element processorChild = (Element)processorChildElements.item(p);
            for (int x = 0; x < childs.getLength(); ++x) {
                String childname = ((Element)childs.item(x)).getAttribute("name");
                this.logger.debug((Object)("--- Parsing " + childname + " child"));
                if (!childname.toLowerCase().contains(processorChild.getAttribute("name"))) continue;
                Element group = (Element)childs.item(x).getParentNode();
                processorChild.setAttribute("group", group.getAttribute("caption"));
            }
            this.addStudioPropertiesToChildElement(processorChild);
        }
    }

    public void addStudioPropertiesToChildElement(Element childElementFromSchema) throws XPathExpressionException {
        this.logger.debug((Object)"- Add Studio Properties to ChildElement");
        this.logger.debug((Object)("-- ChildElement " + childElementFromSchema.getAttribute("name")));
        Element nestedDefinition = this.nestedElements.get(childElementFromSchema.getAttribute("name"));
        if (nestedDefinition != null) {
            NodeList childAttribsFromSchema = this.xPath.evaluateOnElementAndGetNodeList(childElementFromSchema, "./attributes");
            for (int i = 0; i < childAttribsFromSchema.getLength(); ++i) {
                Element attributesNode = (Element)childAttribsFromSchema.item(i);
                String groupController = attributesNode.getAttribute("controlled");
                String expression = "./*[@name='" + groupController + "']";
                Element controller = (Element)this.xPath.evaluateOnElementAndGetNode(nestedDefinition, expression);
                if (controller != null) {
                    attributesNode.setAttribute("controllerType", controller.getTagName());
                    attributesNode.setAttribute("caption", controller.getAttribute("caption"));
                }
                this.parseChildElementAttributeFromAttributesNode(nestedDefinition, attributesNode);
            }
            NodeList childChildsFromSchema = this.xPath.evaluateOnElementAndGetNodeList(childElementFromSchema, "./childElements");
            for (int i = 0; i < childChildsFromSchema.getLength(); ++i) {
                Element childNode = (Element)childChildsFromSchema.item(i);
                this.addStudioPropertiesToChildElement(childNode);
            }
        } else {
            Element parent = (Element)childElementFromSchema.getParentNode();
            parent.removeChild(childElementFromSchema);
        }
    }

    private void parseChildElementAttributeFromAttributesNode(Element nestedDefinition, Element attributesNode) throws XPathExpressionException {
        this.logger.debug((Object)"- Parse Child Element Attribute From Attributes Node");
        String prefix = attributesNode.getAttribute("controlled") + attributesNode.getAttribute("caption") + attributesNode.getAttribute("controllerType");
        for (int p = 0; p < attributesNode.getChildNodes().getLength(); ++p) {
            Element attribute = (Element)attributesNode.getChildNodes().item(p);
            String name = attribute.getAttribute("name");
            if (this.isConfigAttribute(name)) continue;
            if (this.attributesIndex.containsKey(prefix + name)) {
                this.copyNodeFromCachedNode(attribute, this.attributesIndex.get(prefix + name));
                continue;
            }
            this.populateAttributesNodeFieldsFromNestedDefinition(nestedDefinition, attribute, name);
            this.attributesIndex.put(prefix + name, attribute);
        }
    }

    private void populateAttributesNodeFieldsFromNestedDefinition(Element nestedDefinition, Element attribute, String name) throws XPathExpressionException {
        String nameExp = "./*[@name='" + name + "']";
        Element field = (Element)this.xPath.evaluateOnElementAndGetNode(nestedDefinition, nameExp);
        if (field != null) {
            Utils.copyFieldPropertiesToAttributeNode(attribute, field);
        } else {
            Element nestedBase;
            String baseName = attribute.getAttribute("base");
            if (!baseName.equals("") && (nestedBase = this.nestedElements.get(baseName)) != null && (field = (Element)this.xPath.evaluateOnElementAndGetNode(nestedBase, nameExp)) != null) {
                Utils.copyFieldPropertiesToAttributeNode(attribute, field);
            }
        }
    }

    private void copyNodeFromCachedNode(Element emptyElement, Element cachedElement) {
        NamedNodeMap cachedAttributes = cachedElement.getAttributes();
        for (int i = 0; i < cachedAttributes.getLength(); ++i) {
            Node attr = cachedAttributes.item(i);
            emptyElement.setAttribute(attr.getNodeName(), attr.getNodeValue());
        }
    }

    public void addStudioAttributePropertiesToGlobalConfig(Element configElementFromSchema) throws XPathExpressionException {
        NodeList globalElements = this.editorsDoc.getDocumentElement().getElementsByTagName("global-cloud-connector");
        for (int i = 0; i < globalElements.getLength(); ++i) {
            Element cloudElem = (Element)globalElements.item(i);
            Element config = this.xPath.getFirstElementWithTag(configElementFromSchema, cloudElem.getAttribute("localId"));
            Element attributeCategory = this.xPath.getFirstElementWithTag(cloudElem, "attribute-category");
            if (config == null || attributeCategory == null) continue;
            this.setConnectorToolName(configElementFromSchema, cloudElem);
            NodeList configAttributes = this.xPath.evaluateOnElementAndGetNodeList(config, "./attributes/*");
            for (int p = 0; p < configAttributes.getLength(); ++p) {
                Element attribute = (Element)configAttributes.item(p);
                String name = attribute.getAttribute("name");
                String expression = "./*/*[@name='" + name + "']";
                Element field = (Element)this.xPath.evaluateOnElementAndGetNode(attributeCategory, expression);
                if (field != null) {
                    Utils.copyFieldPropertiesToAttributeNode(attribute, field);
                    Element group = (Element)field.getParentNode();
                    attribute.setAttribute("group", group.getAttribute("caption"));
                    continue;
                }
                Element parent = (Element)attribute.getParentNode();
                parent.removeChild(attribute);
            }
        }
    }

    private void setConnectorToolName(Element configElementFromSchema, Element cloudElem) {
        String connectorName = cloudElem.getAttribute("caption");
        ((Element)configElementFromSchema.getOwnerDocument().getFirstChild()).setAttribute("name", connectorName);
    }
}

