/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata.templates;

import com.mule.connectors.testdata.utils.DocumentHandler;
import com.mule.connectors.testdata.utils.Utils;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.WordUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AutomationBeansTemplate {
    private DocumentHandler beansDoc = new DocumentHandler();
    private Element beansRoot = this.beansDoc.createRootElement("beans");

    public AutomationBeansTemplate() throws ParserConfigurationException {
        this.beansRoot.setAttribute("xmlns", "http://www.springframework.org/schema/beans");
        this.beansRoot.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.beansRoot.setAttribute("xmlns:util", "http://www.springframework.org/schema/util");
        this.beansRoot.setAttribute("xmlns:tx", "http://www.springframework.org/schema/tx");
        this.beansRoot.setAttribute("xmlns:aop", "http://www.springframework.org/schema/aop");
        this.beansRoot.setAttribute("xsi:schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.5.xsd\nhttp://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util-2.5.xsd\nhttp://www.springframework.org/schema/tx http://www.springframework.org/schema/tx/spring-tx-2.5.xsd\nhttp://www.springframework.org/schema/aop http://www.springframework.org/schema/aop/spring-aop-2.5.xsd");
    }

    public void createAutomationBeansFromProcessors(Element messageProcessors) throws ParserConfigurationException, TransformerException {
        NodeList processorNodes = messageProcessors.getChildNodes();
        for (int i = 0; i < processorNodes.getLength(); ++i) {
            if (processorNodes.item(i).getNodeType() != 1) continue;
            Element processor = (Element)processorNodes.item(i);
            StringBuilder nameBuilder = new StringBuilder();
            String testCaseName = WordUtils.capitalizeFully((String)Utils.toHumanReadable(processor.getTagName())).replace(" ", "");
            nameBuilder.append("test").append(testCaseName).append("TestData");
            Element utilsMap = this.beansDoc.createElement("util:map");
            utilsMap.setAttribute("id", nameBuilder.toString());
            utilsMap.setAttribute("map-class", "java.util.HashMap");
            utilsMap.setAttribute("scope", "prototype");
            utilsMap.setAttribute("key-type", "java.lang.String");
            utilsMap.setAttribute("value-type", "java.lang.Object");
            utilsMap.setTextContent("\n ");
            NodeList requiredNodes = processor.getElementsByTagName("required");
            for (int attrIndx = 0; attrIndx < requiredNodes.getLength(); ++attrIndx) {
                Element attribute = (Element)requiredNodes.item(attrIndx);
                Element entry = this.beansDoc.createElement("entry");
                entry.setAttribute("key", attribute.getAttribute("name"));
                entry.setAttribute("value", "");
                utilsMap.appendChild(entry);
            }
            NodeList optionalNodes = processor.getElementsByTagName("optional");
            for (int attrIndx = 0; attrIndx < optionalNodes.getLength(); ++attrIndx) {
                Element attribute = (Element)optionalNodes.item(attrIndx);
                Element entry = this.beansDoc.createElement("entry");
                entry.setAttribute("key", attribute.getAttribute("name"));
                entry.setAttribute("value", attribute.getAttribute("default"));
                utilsMap.appendChild(entry);
            }
            this.beansRoot.appendChild(utilsMap);
        }
    }

    public void exportToFile() throws TransformerException {
        this.beansDoc.exportToFile("AutomationSpringBeans.xml");
    }
}

