/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata.templates;

import com.mule.connectors.testdata.model.ConnectorProcessorInfo;
import com.mule.connectors.testdata.utils.DocumentHandler;
import com.mule.connectors.testdata.utils.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesOverriderTemplate {
    private Logger logger = Logger.getLogger(PropertiesOverriderTemplate.class);
    private DocumentHandler docHandler;
    private Element root;
    private Element simpleConfig = null;
    private Element oauthConfig = null;
    private Element messageProcessors;
    private Element properties;
    private String outputFile;
    private XPath xPath = XPathFactory.newInstance().newXPath();

    public PropertiesOverriderTemplate(String connectorName, String originalOutputFile) throws ParserConfigurationException {
        this.logger.debug((Object)"- Properties Override Template initialize");
        this.outputFile = originalOutputFile.replace(".xml", "-override.xml");
        this.docHandler = new DocumentHandler();
        this.root = this.docHandler.createRootElement("connector");
        this.root.setAttribute("name", connectorName);
    }

    public void setPropertiesElement(Element connectorProperties) {
        this.logger.info((Object)"-- Setting Connector Properties Element");
        if (connectorProperties != null) {
            this.properties = (Element)this.docHandler.importNode(connectorProperties, true);
        } else {
            this.createConnectorDefaultProperties();
        }
    }

    private void createConnectorDefaultProperties() {
        this.logger.debug((Object)"- Create Connector Default Properties");
        this.properties = this.docHandler.createElement("properties");
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put("OAuth-authentication", "false");
        defaultProps.put("connectivity-support", "true");
        defaultProps.put("datasense-enabled", "true");
        defaultProps.put("metadata", "static");
        defaultProps.put("transformer", "false");
        for (String key : defaultProps.keySet()) {
            Element node = this.docHandler.createElement(key);
            node.setTextContent((String)defaultProps.get(key));
            this.properties.appendChild(node);
        }
    }

    public void setMessageProcessorsElement(Element processors, Map<String, ConnectorProcessorInfo> processorsProperties) throws XPathExpressionException {
        this.logger.info((Object)"-- Merging Processors Elements");
        this.logger.debug((Object)"- Set Message Processors Element");
        this.messageProcessors = this.docHandler.createElement("message-processors");
        NodeList childs = processors.getChildNodes();
        this.logger.debug((Object)("-- Found " + childs.getLength() + " procesors"));
        for (int i = 0; i < childs.getLength(); ++i) {
            Element processorFromSchema = (Element)childs.item(i);
            String processorName = processorFromSchema.getTagName();
            this.logger.debug((Object)("--- Creating " + processorName + " processor element"));
            Element processor = this.docHandler.createElement(processorName);
            processor.setAttribute("name", Utils.toHumanReadable(processorFromSchema.getTagName()));
            this.setProcessorProperties(processor, processorsProperties.get(processorName));
            Element attributes = this.importRequiredAttributesFromSchemaOutput(processorFromSchema);
            processor.appendChild(attributes);
            Element childElem = this.importChildElementsFromSchemaOutput(processorFromSchema, "required");
            processor.appendChild(childElem);
            this.messageProcessors.appendChild(processor);
        }
    }

    private Element importRequiredAttributesFromSchemaOutput(Element processorFromSchema) throws XPathExpressionException {
        this.logger.debug((Object)"- Import Required Attributes From Schema Output");
        Element attributes = this.docHandler.createElement("attributes");
        NodeList required = (NodeList)this.xPath.compile("./attributes/required").evaluate(processorFromSchema, XPathConstants.NODESET);
        for (int node = 0; node < required.getLength(); ++node) {
            Element attr = (Element)this.docHandler.importNode(required.item(node), false);
            attr.setTextContent(" ");
            attributes.appendChild(attr);
        }
        return attributes;
    }

    private void setProcessorProperties(Element processor, ConnectorProcessorInfo processorProperties) {
        this.logger.debug((Object)("- Set Properties for Processor :: " + processor.getTagName()));
        if (processorProperties != null) {
            Element dmap = this.docHandler.createElement("datamapper");
            dmap.setAttribute("output", processorProperties.getOuputDataMapperType());
            dmap.setAttribute("input", processorProperties.getInputDataMapperType());
            processor.appendChild(dmap);
            Element pag = this.docHandler.createElement("auto-paging");
            pag.setTextContent(processorProperties.hasAutoPaging().toString());
            processor.appendChild(pag);
            Element query = this.docHandler.createElement("query-support");
            query.setTextContent(processorProperties.hasQuerySupport().toString());
            processor.appendChild(query);
        } else {
            this.logger.debug((Object)"-- Using Default Properties");
            this.createProcessorDefaultProperties(processor);
        }
    }

    private void createProcessorDefaultProperties(Element processor) {
        this.logger.debug((Object)"- Create Default Properties");
        Element dmap = this.docHandler.createElement("datamapper");
        dmap.setAttribute("output", "");
        dmap.setAttribute("input", "");
        processor.appendChild(dmap);
        Element pag = this.docHandler.createElement("auto-paging");
        pag.setTextContent("false");
        processor.appendChild(pag);
        Element query = this.docHandler.createElement("query-support");
        query.setTextContent("false");
        processor.appendChild(query);
    }

    private Element importChildElementsFromSchemaOutput(Element source, String type) throws XPathExpressionException {
        this.logger.debug((Object)"- Import ChildElements From SchemaOutput");
        Element childElem = this.docHandler.createElement("childElements");
        NodeList nodes = (NodeList)this.xPath.compile("./childElements/" + type).evaluate(source, XPathConstants.NODESET);
        this.logger.debug((Object)("-- Found " + nodes.getLength() + " childs"));
        for (int nodeIndx = 0; nodeIndx < nodes.getLength(); ++nodeIndx) {
            Element child = this.importChildElement((Element)nodes.item(nodeIndx));
            childElem.appendChild(child);
        }
        return childElem;
    }

    private Element importChildElement(Element source) throws XPathExpressionException {
        this.logger.debug((Object)"- Import ChildElement From Source");
        Element parentChild = this.docHandler.createElement(source.getTagName());
        parentChild.setAttribute("name", source.getAttribute("name"));
        parentChild.setAttribute("group", source.getAttribute("group"));
        NodeList attributesSources = (NodeList)this.xPath.compile("./attributes").evaluate(source, XPathConstants.NODESET);
        for (int i = 0; i < attributesSources.getLength(); ++i) {
            Element attributesSource = (Element)attributesSources.item(i);
            Element attributes = this.docHandler.createElement("attributes");
            attributes.setAttribute("caption", attributesSource.getAttribute("caption"));
            attributes.setAttribute("controlled", attributesSource.getAttribute("controlled"));
            attributes.setAttribute("controllerType", attributesSource.getAttribute("controllerType"));
            NodeList required = (NodeList)this.xPath.compile("./required").evaluate(attributesSource, XPathConstants.NODESET);
            for (int node = 0; node < required.getLength(); ++node) {
                Element attr = (Element)this.docHandler.importNode(required.item(node), false);
                attr.setTextContent(" ");
                attributes.appendChild(attr);
            }
            parentChild.appendChild(attributes);
        }
        Element childElem = this.importChildElementsFromSchemaOutput(source, "required");
        parentChild.appendChild(childElem);
        return parentChild;
    }

    private Element cloneNode(Element origin, String tagName) {
        Element node = this.docHandler.createElement(tagName);
        node.setAttribute("caption", origin.getAttribute("caption"));
        node.setAttribute("name", origin.getAttribute("name"));
        node.setAttribute("type", origin.getAttribute("type"));
        node.setAttribute("javaType", origin.getAttribute("javaType"));
        node.setAttribute("group", origin.getAttribute("group"));
        node.setTextContent(" ");
        return node;
    }

    public void exportToFile() throws TransformerException {
        this.logger.debug((Object)"- Export to File");
        this.buildOutputDocument();
        this.docHandler.exportToFile(this.outputFile);
    }

    private void buildOutputDocument() {
        this.logger.debug((Object)"- Build Output Document");
        this.root.appendChild(this.properties);
        if (this.simpleConfig != null) {
            this.root.appendChild(this.simpleConfig);
        }
        if (this.oauthConfig != null) {
            this.root.appendChild(this.oauthConfig);
        }
        this.root.appendChild(this.messageProcessors);
    }

    public void setConfigElement(Element globalConfigElement, String credentialsFile) throws IOException, XPathExpressionException {
        this.logger.debug((Object)"- Set Config Element");
        this.logger.info((Object)"-- Setting Connector Config Element");
        if (globalConfigElement.getElementsByTagName("config").getLength() > 0) {
            this.logger.debug((Object)"-- Creating Simple Config Override");
            this.simpleConfig = this.docHandler.createElement("simpleConfig");
            Element userPswdConfig = (Element)globalConfigElement.getElementsByTagName("config").item(0);
            this.setConfigNameAttribute(userPswdConfig, this.simpleConfig);
            if (!credentialsFile.equals(" ")) {
                this.parseCredentialsFromFile(userPswdConfig, this.simpleConfig, credentialsFile);
            } else {
                this.createDefaultConfig(userPswdConfig, this.simpleConfig);
            }
        }
        if (globalConfigElement.getElementsByTagName("config-with-oauth").getLength() > 0) {
            this.logger.debug((Object)"-- Creating OAuth Config Override");
            this.oauthConfig = this.docHandler.createElement("oauthConfig");
            Element oauth = (Element)globalConfigElement.getElementsByTagName("config-with-oauth").item(0);
            this.setConfigNameAttribute(oauth, this.oauthConfig);
            if (!credentialsFile.equals(" ")) {
                this.parseCredentialsFromFile(oauth, this.oauthConfig, credentialsFile);
            } else {
                this.createDefaultConfig(oauth, this.oauthConfig);
            }
        }
    }

    private void setConfigNameAttribute(Element source, Element destination) throws XPathExpressionException {
        String nameExpression = "./attributes/*[@name='name']";
        Element origin = (Element)this.xPath.compile(nameExpression).evaluate(source, XPathConstants.NODE);
        if (origin != null) {
            Element node = this.cloneNode(origin, "required");
            node.setTextContent(" ");
            destination.appendChild(node);
        }
    }

    private void createDefaultConfig(Element source, Element destination) {
        this.logger.debug((Object)"- Create Default Config");
        NodeList required = source.getElementsByTagName("required");
        for (int i = 0; i < required.getLength(); ++i) {
            Element node = (Element)this.docHandler.importNode(required.item(i), false);
            node.setAttribute("prefix", "");
            node.setTextContent(" ");
            destination.appendChild(node);
        }
    }

    private void parseCredentialsFromFile(Element source, Element destination, String file) throws IOException, XPathExpressionException {
        this.logger.info((Object)"-- Parsing Credentials From File");
        this.logger.debug((Object)"- Parse Credentials From File");
        BufferedReader br = null;
        try {
            String currentLine;
            br = new BufferedReader(new FileReader(file));
            while ((currentLine = br.readLine()) != null) {
                this.createRequiredNodeFromCredential(source, destination, currentLine);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (XPathExpressionException e) {
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private void createRequiredNodeFromCredential(Element source, Element destination, String currentLine) throws XPathExpressionException {
        this.logger.debug((Object)"- Create RequiredNode From Credentials");
        int indexOfDot = currentLine.indexOf(".");
        int indexOfEqual = currentLine.indexOf("=");
        String prefix = indexOfDot != -1 ? currentLine.substring(0, indexOfDot) : "";
        String fieldName = currentLine.substring(indexOfDot + 1, indexOfEqual);
        String value = currentLine.substring(indexOfEqual + 1);
        String attrWithNameExpression = "./attributes/*[@name='" + fieldName + "']";
        Element origin = (Element)this.xPath.compile(attrWithNameExpression).evaluate(source, XPathConstants.NODE);
        if (origin != null) {
            this.logger.debug((Object)("-- Read attribute :: " + fieldName));
            Element node = this.cloneNode(origin, "required");
            node.setAttribute("prefix", prefix);
            node.setTextContent(value);
            destination.appendChild(node);
        }
    }
}

