/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata.utils;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DocumentHandler {
    private Logger logger = Logger.getLogger(DocumentHandler.class);
    private static String outputPath = "";
    private Document doc;

    public DocumentHandler() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.newDocument();
    }

    public DocumentHandler(String sourceFile) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.parse(sourceFile);
    }

    public DocumentHandler(File sourceFile) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.parse(sourceFile);
    }

    public static void setOutputPath(String path) {
        if (path.charAt(path.length() - 1) != File.separatorChar) {
            path = path + File.separatorChar;
        }
        outputPath = path;
    }

    public Node importNode(Node node, boolean deep) {
        return this.doc.importNode(node, deep);
    }

    public Element createRootElement(String name) {
        Element rootOutElem = this.doc.createElement(name);
        this.doc.appendChild(rootOutElem);
        return rootOutElem;
    }

    public Element createElement(String name) {
        return this.doc.createElement(name);
    }

    public void exportToFile(String filename) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(this.doc);
        new File(outputPath).mkdirs();
        File exportedFile = new File(outputPath + filename);
        if (!exportedFile.exists()) {
            StreamResult result = new StreamResult(exportedFile);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
        } else {
            this.logger.warn((Object)("File " + filename + " already exist in directory " + outputPath));
            this.logger.error((Object)(" Skipping creation of " + filename));
        }
    }

    public Document getDoc() {
        return this.doc;
    }

    public Element getDocumentElement() {
        return this.doc.getDocumentElement();
    }
}

