/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class Utils {
    private static final Pattern camelCaseToMuleXmlPattern = Pattern.compile("([A-Z0-9])");

    public static String transformCamelCaseToXmlName(String camelName) {
        if (camelName == null || camelName.isEmpty()) {
            return null;
        }
        Matcher matcher = camelCaseToMuleXmlPattern.matcher(camelName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "-" + matcher.group(1).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String toHumanReadable(String str) {
        String name = str.replaceAll("-", " ");
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    public static void copyFieldPropertiesToAttributeNode(Element attribute, Element field) {
        attribute.setAttribute("type", field.getTagName());
        attribute.setAttribute("caption", field.getAttribute("caption"));
        String javaType = field.getAttribute("javaType");
        javaType = javaType.equals("") ? "java.lang.String" : javaType;
        attribute.setAttribute("javaType", javaType);
    }
}

