/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata.utils;

import com.mule.connectors.testdata.utils.UniversalNamespaceResolver;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathEvaluator {
    private Document doc;
    private XPath xPathParser = XPathFactory.newInstance().newXPath();

    public XPathEvaluator(Document sourceDoc) {
        this.doc = sourceDoc;
        this.xPathParser.setNamespaceContext(new UniversalNamespaceResolver(this.doc));
    }

    public NodeList evaluateOnDocAndGetNodeList(String expression) throws XPathExpressionException {
        return (NodeList)this.xPathParser.compile(expression).evaluate(this.doc, XPathConstants.NODESET);
    }

    public NodeList evaluateOnElementAndGetNodeList(Element elem, String expression) throws XPathExpressionException {
        return (NodeList)this.xPathParser.compile(expression).evaluate(elem, XPathConstants.NODESET);
    }

    public Node evaluateOnElementAndGetNode(Element elem, String expression) throws XPathExpressionException {
        return (Node)this.xPathParser.compile(expression).evaluate(elem, XPathConstants.NODE);
    }

    public boolean hasChildElement(Element parent, String childName) {
        NodeList nodes = parent.getChildNodes();
        boolean found = false;
        for (int i = 0; !found && i < nodes.getLength(); ++i) {
            Node current = nodes.item(i);
            found = current.getNodeName().contains(childName);
        }
        return found;
    }

    public Element getFirstElementWithTag(String tag) {
        return this.getFirstElementWithTag(this.doc.getDocumentElement(), tag);
    }

    public Element getFirstElementWithTag(Element parent, String tag) {
        NodeList foundElements = parent.getElementsByTagName(tag);
        if (foundElements.getLength() > 0) {
            return (Element)foundElements.item(0);
        }
        return null;
    }
}

