/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding;

import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.api.ApiReference;
import org.mule.dx.contributions.exception.ComponentException;
import org.mule.dx.contributions.exception.ParsingException;
import org.mule.dx.contributions.exception.ScaffoldingException;
import org.mule.dx.contributions.jsonrpc.ScaffoldingService;
import org.mule.dx.contributions.scaffolding.handler.ProjectHandler;
import org.mule.dx.contributions.scaffolding.handler.ResponseHandler;
import org.mule.dx.contributions.scaffolding.model.ScaffoldRequest;
import org.mule.dx.contributions.scaffolding.model.ScaffoldResponse;
import org.mule.dx.contributions.utils.ResourceLoaderFactory;
import org.mule.dx.platform.api.WorkspaceManager;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.parser.service.ParserService;
import org.mule.parser.service.result.ParseResult;
import org.mule.tools.apikit.MainAppScaffolder;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.mule.tools.apikit.model.ScaffolderContext;
import org.mule.tools.apikit.model.ScaffolderContextBuilder;
import org.mule.tools.apikit.model.ScaffoldingConfiguration;
import org.mule.tools.apikit.model.ScaffoldingResult;

public class ScaffoldingServiceImpl
implements ScaffoldingService {
    @Inject
    private WorkspaceManager workspaceManager;
    private ProjectHandler projectHandler;
    @Inject
    private GraphQlClient graphQlClient;

    @Override
    public CompletableFuture<ScaffoldResponse> scaffold(ScaffoldRequest request) {
        String apiUri = request.getApiUri();
        if (StringUtils.isBlank((CharSequence)apiUri)) {
            return CompletableFuture.completedFuture(ResponseHandler.createErrorResponse(new ComponentException("API location cannot be null")));
        }
        if (this.projectHandler == null) {
            this.projectHandler = new ProjectHandler(this.workspaceManager, this.graphQlClient);
        }
        return this.scaffold(ApiReference.create((String)apiUri, (ResourceLoader)ResourceLoaderFactory.getResourceLoader(apiUri)), request.getProjectId());
    }

    private CompletableFuture<ScaffoldResponse> scaffold(ApiReference apiReference, String projectId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ScaffoldingConfiguration configuration;
                ParseResult parseResult = new ParserService().parse(apiReference);
                if (!parseResult.success()) {
                    throw new ParsingException(parseResult);
                }
                ScaffolderContext context = ScaffolderContextBuilder.builder().withRuntimeEdition(RuntimeEdition.EE).build();
                MainAppScaffolder mainAppScaffolder = new MainAppScaffolder(context);
                ScaffoldingResult scaffoldResult = mainAppScaffolder.run(configuration = new ScaffoldingConfiguration.Builder().withApi(parseResult.get()).withMuleConfigurations(this.projectHandler.getMuleConfigFiles(projectId)).build());
                if (!scaffoldResult.isSuccess()) {
                    throw new ScaffoldingException(scaffoldResult);
                }
                List<String> muleConfigUris = this.projectHandler.persistScaffoldingConfigs(projectId, scaffoldResult.getGeneratedConfigs());
                this.projectHandler.addRequiredDependencies(projectId);
                return ResponseHandler.createSuccessResponse(muleConfigUris);
            }
            catch (ComponentException e) {
                return ResponseHandler.createErrorResponse(e);
            }
            catch (Exception e) {
                return ResponseHandler.createErrorResponse(new ComponentException(e));
            }
        });
    }
}

