/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding.handler;

import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.mule.dx.platform.api.dependency.DependencyModel;
import org.mule.dx.platform.api.dependency.DependencyModelManager;
import org.mule.dx.platform.api.dependency.DependencyModelMutator;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.dx.platform.api.maven.Scope;
import org.mule.dx.platform.api.project.Project;
import org.mule.runtime.api.util.LazyValue;

public class DependenciesHandler {
    private static final String DEFAULT_APIKIT_VERSION = "1.5.5";
    private static Pattern VERSION_PATTERN = Pattern.compile("\\\"version\\\":\\\"(.*)\\\"");
    private GraphQlClient graphQlClient;
    private LazyValue<String> version = new LazyValue(() -> this.getVersion());
    private static String VERSION_EXCHANGE_QUERY = "{\n  asset(groupId: \"org.mule.modules\", assetId: \"mule-apikit-module\") {\n    version\n  }\n}";

    private String getVersion() {
        return this.getVersionFromExchange().orElse(DEFAULT_APIKIT_VERSION);
    }

    private Optional<String> getVersionFromExchange() {
        String assets = this.graphQlClient.query(VERSION_EXCHANGE_QUERY, Optional.empty());
        Matcher versionMatcher = VERSION_PATTERN.matcher(assets);
        return versionMatcher.find() ? Optional.of(versionMatcher.group(1)) : Optional.empty();
    }

    public DependenciesHandler(GraphQlClient graphQlClient) {
        this.graphQlClient = graphQlClient;
    }

    public void addDependencies(Project project) throws RuntimeException {
        DependencyModelManager modelManager = (DependencyModelManager)project.getComponent(DependencyModelManager.class).orElseThrow(() -> new RuntimeException("Failed to add APIKit Module dependency"));
        Optional mutator = modelManager.mutator();
        boolean success = ((DependencyModelMutator)mutator.get()).addDependency((DependencyModel)new MavenDependencyModel(){

            public String getGroupId() {
                return "org.mule.modules";
            }

            public String getArtifactId() {
                return "mule-apikit-module";
            }

            public String getBaseVersion() {
                return null;
            }

            public String getType() {
                return null;
            }

            public Optional<String> getClassifier() {
                return Optional.of("mule-plugin");
            }

            public Scope getScope() {
                return null;
            }

            public Dependency toMavenNativeModel() {
                Dependency dependency = new Dependency();
                dependency.setGroupId("org.mule.modules");
                dependency.setArtifactId("mule-apikit-module");
                dependency.setVersion((String)DependenciesHandler.this.version.get());
                dependency.setClassifier("mule-plugin");
                return dependency;
            }

            public String getId() {
                return null;
            }

            public Collection<DependencyModel> getDependencies() {
                return null;
            }

            public String getSystemID() {
                return null;
            }

            public String getVersion() {
                return (String)DependenciesHandler.this.version.get();
            }

            public URI getLocation() {
                return null;
            }
        });
        if (!success) {
            throw new RuntimeException("Failed to add APIKit Module dependency");
        }
        ((DependencyModelMutator)mutator.get()).persist();
    }
}

