/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.dx.contributions.scaffolding.handler.DependenciesHandler;
import org.mule.dx.platform.api.WorkspaceManager;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.dx.platform.api.project.Project;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.MuleConfigBuilder;

public class ProjectHandler {
    private WorkspaceManager workspaceManager;
    private DependenciesHandler dependenciesHandler;

    public ProjectHandler(WorkspaceManager workspaceManager, GraphQlClient graphQlClient) {
        this.workspaceManager = workspaceManager;
        this.dependenciesHandler = new DependenciesHandler(graphQlClient);
    }

    private Project getProject(String projectId) {
        if (StringUtils.isBlank((CharSequence)projectId)) {
            throw new RuntimeException("Project ID cannot be null");
        }
        Optional iProject = this.workspaceManager.getProjectById(projectId);
        return (Project)iProject.orElseThrow(() -> new RuntimeException(String.format("Project ID %s does not exist", projectId)));
    }

    public List<MuleConfig> getMuleConfigFiles(String projectId) {
        Project iProject = this.getProject(projectId);
        URI location = iProject.getLocation();
        if (location == null) {
            throw new RuntimeException("API location cannot be null");
        }
        Collection fileList = FileUtils.listFiles((File)new File(Paths.get(location.getPath(), "src", "main", "mule").toUri()), (String[])new String[]{"xml"}, (boolean)true);
        return fileList.stream().map(file -> ProjectHandler.mapToMuleConfig(file)).collect(Collectors.toList());
    }

    private static MuleConfig mapToMuleConfig(File file) {
        try {
            MuleConfig muleConfig = MuleConfigBuilder.fromStream((InputStream)new FileInputStream(file));
            muleConfig.setName(file.getName());
            return muleConfig;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addRequiredDependencies(String projectId) {
        if (this.dependenciesHandler != null) {
            this.dependenciesHandler.addDependencies(this.getProject(projectId));
        }
    }

    public List<String> persistScaffoldingConfigs(String projectId, List<MuleConfig> configs) throws IOException {
        Project project = this.getProject(projectId);
        String rootPath = Paths.get(project.getLocation()).toString();
        ArrayList<String> muleConfigUris = new ArrayList<String>();
        for (MuleConfig config : configs) {
            Path configPath = Paths.get(rootPath, "src", "main", "mule", config.getName());
            URI muleConfigUri = configPath.toUri();
            muleConfigUris.add(muleConfigUri.toString());
            File configFile = new File(muleConfigUri);
            FileOutputStream fileOutputStream = new FileOutputStream(configFile);
            IOUtils.copy((InputStream)config.getContent(), (OutputStream)fileOutputStream);
        }
        return muleConfigUris;
    }
}

