/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding.handler;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.mule.dx.contributions.scaffolding.APIKitDependency;
import org.mule.dx.contributions.scaffolding.Dependency;
import org.mule.dx.contributions.scaffolding.GraphQLDependency;
import org.mule.dx.platform.api.dependency.DependencyModel;
import org.mule.dx.platform.api.dependency.DependencyModelManager;
import org.mule.dx.platform.api.dependency.DependencyModelMutator;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.dx.platform.api.maven.Scope;
import org.mule.dx.platform.api.project.Project;

public class DependenciesHandler {
    private Map<String, Dependency> dependencies;

    public DependenciesHandler(GraphQlClient graphQlClient) {
        this.dependencies = ImmutableMap.of((Object)"raml", (Object)new APIKitDependency(graphQlClient), (Object)"oas", (Object)new APIKitDependency(graphQlClient), (Object)"graphql", (Object)new GraphQLDependency(graphQlClient));
    }

    public void addDependencies(Project project, String classifier) throws RuntimeException {
        final Dependency moduleDependency = this.dependencies.get(classifier);
        DependencyModelManager modelManager = (DependencyModelManager)project.getComponent(DependencyModelManager.class).orElseThrow(() -> new RuntimeException("Failed to add module dependencies"));
        Optional mutator = modelManager.mutator();
        boolean success = ((DependencyModelMutator)mutator.get()).addDependency((DependencyModel)new MavenDependencyModel(){

            public String getGroupId() {
                return moduleDependency.groupId();
            }

            public String getArtifactId() {
                return moduleDependency.artifactId();
            }

            public String getBaseVersion() {
                return null;
            }

            public String getType() {
                return null;
            }

            public Optional<String> getClassifier() {
                return Optional.of(moduleDependency.classifier());
            }

            public Scope getScope() {
                return null;
            }

            public org.apache.maven.model.Dependency toMavenNativeModel() {
                org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
                dependency.setGroupId(moduleDependency.groupId());
                dependency.setArtifactId(moduleDependency.artifactId());
                dependency.setVersion(moduleDependency.version());
                dependency.setClassifier(moduleDependency.classifier());
                return dependency;
            }

            public String getId() {
                return null;
            }

            public Collection<DependencyModel> getDependencies() {
                return null;
            }

            public String getSystemID() {
                return null;
            }

            public String getVersion() {
                return moduleDependency.version();
            }

            public URI getLocation() {
                return null;
            }
        });
        if (!success) {
            throw new RuntimeException("Failed to add module dependencies");
        }
        ((DependencyModelMutator)mutator.get()).persist();
    }
}

