/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.utils;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.mule.apikit.loader.ResourceLoader;

public class APISyncResourceLoader
implements ResourceLoader {
    private static final String protocol = "jar:file:";
    private static final String API_SYNC_PROTOCOL = "resource::";
    private static final String localRepository = System.getProperty("user.home") + "/.m2/repository";

    public URI getResource(String resource) {
        try {
            if (!this.isSyncProtocol(resource)) {
                return null;
            }
            String[] parts = resource.substring(API_SYNC_PROTOCOL.length()).split(":");
            String groupId = parts[0].replaceAll("\\.", "/");
            String artifact = parts[1];
            String version = parts[2];
            String classifier = parts[3];
            String file = parts[5];
            return new URI(String.format("%s%s/%s/%s/%s/%s-%s-%s.zip!/%s", protocol, localRepository, groupId, artifact, version, artifact, version, classifier, file));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private boolean isSyncProtocol(String resource) {
        return StringUtils.isNotBlank((String)resource) && resource.startsWith(API_SYNC_PROTOCOL);
    }
}

