/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.dx.contributions.scaffolding.handler.DependenciesHandler;
import org.mule.dx.platform.api.WorkspaceManager;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.dx.platform.api.project.Project;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.MuleConfigBuilder;

public class ProjectHandler {
    public static final String MULE_APP_XML_FOLDER = "src/main/mule";
    public static final String MULE_APP_RESOURCES_FOLDER = "src/main/resources";
    private final WorkspaceManager workspaceManager;
    private final DependenciesHandler dependenciesHandler;

    public ProjectHandler(WorkspaceManager workspaceManager, GraphQlClient graphQlClient) {
        this.workspaceManager = workspaceManager;
        this.dependenciesHandler = new DependenciesHandler(graphQlClient);
    }

    private Project getProject(String projectId) {
        if (StringUtils.isBlank((CharSequence)projectId)) {
            throw new RuntimeException("Project ID cannot be null");
        }
        Optional iProject = this.workspaceManager.getProjectById(projectId);
        return (Project)iProject.orElseThrow(() -> new RuntimeException(String.format("Project ID %s does not exist", projectId)));
    }

    public List<MuleConfig> getMuleConfigFiles(String projectId) {
        return this.listConfigFiles(projectId).stream().map(ProjectHandler::mapToMuleConfig).collect(Collectors.toList());
    }

    public Set<String> getMuleConfigFilepaths(String projectId) {
        return this.listConfigFiles(projectId).stream().map(File::toURI).map(URI::toString).collect(Collectors.toSet());
    }

    private Collection<File> listConfigFiles(String projectId) {
        Project project = this.getProject(projectId);
        URI location = project.getLocation();
        if (location == null) {
            throw new RuntimeException("API location cannot be null");
        }
        URI xmlsURI = Paths.get(location.getPath(), MULE_APP_XML_FOLDER).toUri();
        return FileUtils.listFiles((File)new File(xmlsURI), (String[])new String[]{"xml"}, (boolean)true);
    }

    private static MuleConfig mapToMuleConfig(File file) {
        try {
            MuleConfig muleConfig = MuleConfigBuilder.fromStream((InputStream)new FileInputStream(file));
            muleConfig.setName(file.getName());
            return muleConfig;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addRequiredDependencies(String projectId, String classifier) {
        this.dependenciesHandler.addDependencies(this.getProject(projectId), classifier);
    }

    public List<String> persistScaffoldingConfigs(String projectId, List<MuleConfig> configs) throws IOException {
        Map<String, InputStream> files = configs.stream().collect(Collectors.toMap(MuleConfig::getName, MuleConfig::getContent));
        return this.writeFilesToProject(projectId, MULE_APP_XML_FOLDER, files);
    }

    public List<String> writeFilesToProject(String projectId, String projectPath, Map<String, InputStream> files) throws IOException {
        Project project = this.getProject(projectId);
        String rootPath = Paths.get(project.getLocation()).toString();
        ArrayList<String> muleConfigUris = new ArrayList<String>();
        for (Map.Entry<String, InputStream> config : files.entrySet()) {
            URI uri = Paths.get(rootPath, projectPath, config.getKey()).toUri();
            config.getValue().transferTo(new FileOutputStream(new File(uri)));
            muleConfigUris.add(uri.toString());
        }
        return muleConfigUris;
    }
}

