/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.internal.APIKitScaffolder;
import org.mule.apikit.scaffolding.internal.config.ScaffoldingConfigImpl;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphMapper;
import org.mule.apikit.scaffolding.internal.mapper.GraphQLApiGraphMapper;
import org.mule.apikit.scaffolding.internal.template.DataWeaveTemplateEngine;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;
import org.mule.dx.contributions.exception.ParsingException;
import org.mule.dx.contributions.exception.ScaffoldingException;
import org.mule.dx.contributions.jsonrpc.ScaffoldingService;
import org.mule.dx.contributions.scaffolding.handler.ProjectHandler;
import org.mule.dx.contributions.scaffolding.handler.ResponseHandler;
import org.mule.dx.contributions.scaffolding.model.ScaffoldRequest;
import org.mule.dx.contributions.scaffolding.model.ScaffoldResponse;
import org.mule.dx.contributions.utils.ResourceLoaderFactory;
import org.mule.dx.platform.api.WorkspaceManager;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.parser.service.ParserService;
import org.mule.parser.service.result.ParseResult;
import org.mule.tools.apikit.MainAppScaffolder;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.mule.tools.apikit.model.ScaffolderContext;
import org.mule.tools.apikit.model.ScaffolderContextBuilder;
import org.mule.tools.apikit.model.ScaffoldingConfiguration;
import org.mule.tools.apikit.model.ScaffoldingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaffoldingServiceImpl
implements ScaffoldingService {
    private static final Logger logger = LoggerFactory.getLogger(ScaffoldingServiceImpl.class);
    @Inject
    private WorkspaceManager workspaceManager;
    private ProjectHandler projectHandler;
    @Inject
    private GraphQlClient graphQlClient;
    private Set<String> legacyScaffolder = ImmutableSet.of((Object)"raml", (Object)"oas");

    @Override
    public CompletableFuture<ScaffoldResponse> scaffold(ScaffoldRequest request) {
        String apiUri = request.getApiUri();
        logger.info("Got scaffolding request for {}", (Object)apiUri);
        if (StringUtils.isBlank((CharSequence)apiUri)) {
            return CompletableFuture.completedFuture(ResponseHandler.createErrorResponse(new Exception("API location cannot be null")));
        }
        if (this.projectHandler == null) {
            this.projectHandler = new ProjectHandler(this.workspaceManager, this.graphQlClient);
        }
        ApiReference reference = ApiReference.create((String)apiUri, (ResourceLoader)ResourceLoaderFactory.getResourceLoader(apiUri));
        String projectId = request.getProjectId();
        String classifier = ScaffoldingServiceImpl.getClassifier(request.getApiUri());
        return this.requestNeedsLegacyScaffolder(classifier) ? this.scaffoldWithLegacyScaffolder(reference, projectId, classifier) : this.scaffoldWithTemplateScaffolder(reference, projectId, classifier);
    }

    private boolean requestNeedsLegacyScaffolder(String classifier) {
        return this.legacyScaffolder.contains(classifier);
    }

    private static String getClassifier(String apiUri) {
        String[] parts = apiUri.split(":");
        return parts.length == 8 ? parts[5] : null;
    }

    private CompletableFuture<ScaffoldResponse> scaffoldWithLegacyScaffolder(ApiReference apiReference, String projectId, String classifier) {
        return CompletableFuture.supplyAsync(() -> {
            List<String> muleConfigUris;
            ScaffoldingConfiguration configuration;
            logger.info("Scaffolding for {} started (using legacy scaffolder)", (Object)projectId);
            ParseResult parseResult = new ParserService().parse(apiReference);
            if (!parseResult.success()) {
                throw new ParsingException(parseResult);
            }
            ScaffolderContext context = ScaffolderContextBuilder.builder().withRuntimeEdition(RuntimeEdition.EE).build();
            MainAppScaffolder mainAppScaffolder = new MainAppScaffolder(context);
            ScaffoldingResult scaffoldResult = mainAppScaffolder.run(configuration = new ScaffoldingConfiguration.Builder().withApi(parseResult.get()).withMuleConfigurations(this.projectHandler.getMuleConfigFiles(projectId)).build());
            if (!scaffoldResult.isSuccess()) {
                throw new ScaffoldingException(scaffoldResult);
            }
            try {
                muleConfigUris = this.projectHandler.persistScaffoldingConfigs(projectId, scaffoldResult.getGeneratedConfigs());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.projectHandler.addRequiredDependencies(projectId, classifier);
            logger.info("Scaffolding for {} finished successfully", (Object)projectId);
            return ResponseHandler.createSuccessResponse(muleConfigUris);
        }).exceptionally(e -> {
            logger.info("Scaffolding for {} failed", (Object)projectId, e);
            return ResponseHandler.createErrorResponse(e);
        });
    }

    private CompletableFuture<ScaffoldResponse> scaffoldWithTemplateScaffolder(ApiReference apiReference, String projectId, String classifier) {
        return CompletableFuture.supplyAsync(() -> {
            List<String> muleConfigFilenames;
            logger.info("Scaffolding for {} started (using template scaffolder)", (Object)projectId);
            APIKitScaffolder scaffolder = new APIKitScaffolder((ApiGraphMapper)new GraphQLApiGraphMapper(), (TemplateEngine)new DataWeaveTemplateEngine());
            org.mule.apikit.scaffolding.api.ScaffoldingResult result = scaffolder.scaffold((ScaffoldingConfig)new ScaffoldingConfigImpl(apiReference.getLocation(), this.projectHandler.getProjectBasePath(projectId).toString(), this.projectHandler.getMuleConfigFilepaths(projectId), this.projectHandler.getMuleResourceFilepaths(projectId), Map.of("src/main/mule/flows.xml", ScaffoldingServiceImpl.getResourceAsStream("scripts/graphql/flows.dwl"), "src/main/mule/global-configs.xml", ScaffoldingServiceImpl.getResourceAsStream("scripts/graphql/global-configs.dwl"))));
            if (!result.success()) {
                throw new ScaffoldingException(result);
            }
            try {
                muleConfigFilenames = this.projectHandler.writeFilesToProject(projectId, "/", result.generatedMuleXmls());
                this.projectHandler.writeFilesToProject(projectId, "/", result.generatedPropertiesFiles());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.projectHandler.addRequiredDependencies(projectId, classifier);
            logger.info("Scaffolding for {} finished successfully", (Object)projectId);
            return ResponseHandler.createSuccessResponse(muleConfigFilenames);
        }).exceptionally(e -> {
            logger.info("Scaffolding for {} failed", (Object)projectId, e);
            return ResponseHandler.createErrorResponse(e);
        });
    }

    private static InputStream getResourceAsStream(String resourceName) {
        return APIKitScaffolder.class.getClassLoader().getResourceAsStream(resourceName);
    }
}

