/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.dx.contributions.scaffolding.APIKitDependency;
import org.mule.dx.contributions.scaffolding.Dependency;
import org.mule.dx.contributions.scaffolding.GraphQLDependency;
import org.mule.dx.contributions.scaffolding.HTTPDependency;
import org.mule.dx.platform.api.dependency.DependencyModel;
import org.mule.dx.platform.api.dependency.DependencyModelManager;
import org.mule.dx.platform.api.dependency.DependencyModelMutator;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.dx.platform.api.maven.Scope;
import org.mule.dx.platform.api.project.Project;

public class DependenciesHandler {
    private Map<String, List<Dependency>> dependencies;

    public DependenciesHandler(GraphQlClient graphQlClient) {
        ImmutableList restDependencies = ImmutableList.of((Object)new APIKitDependency(graphQlClient), (Object)new HTTPDependency(graphQlClient));
        ImmutableList graphqlDependencies = ImmutableList.of((Object)new GraphQLDependency(graphQlClient), (Object)new HTTPDependency(graphQlClient));
        this.dependencies = ImmutableMap.of((Object)"raml", (Object)restDependencies, (Object)"oas", (Object)restDependencies, (Object)"graphql", (Object)graphqlDependencies, (Object)"light-graphql", (Object)graphqlDependencies, (Object)"graphql-apollo", (Object)graphqlDependencies, (Object)"light-graphql-apollo", (Object)graphqlDependencies);
    }

    public void addDependencies(Project project, String classifier) throws RuntimeException {
        List<Dependency> moduleDependencies = this.dependencies.get(classifier);
        DependencyModelManager modelManager = (DependencyModelManager)project.getComponent(DependencyModelManager.class).orElseThrow(() -> new RuntimeException("Failed to add module dependencies"));
        DependencyModelMutator mutator = (DependencyModelMutator)modelManager.mutator().get();
        moduleDependencies.forEach(moduleDependency -> {
            boolean success = mutator.addDependency((DependencyModel)new MavenDependencyModel((Dependency)moduleDependency){
                final /* synthetic */ Dependency val$moduleDependency;
                {
                    this.val$moduleDependency = dependency;
                }

                public String getGroupId() {
                    return this.val$moduleDependency.groupId();
                }

                public String getArtifactId() {
                    return this.val$moduleDependency.artifactId();
                }

                public String getBaseVersion() {
                    return null;
                }

                public String getType() {
                    return null;
                }

                public Optional<String> getClassifier() {
                    return Optional.of(this.val$moduleDependency.classifier());
                }

                public Scope getScope() {
                    return null;
                }

                public org.apache.maven.model.Dependency toMavenNativeModel() {
                    org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
                    dependency.setGroupId(this.val$moduleDependency.groupId());
                    dependency.setArtifactId(this.val$moduleDependency.artifactId());
                    dependency.setVersion(this.val$moduleDependency.version());
                    dependency.setClassifier(this.val$moduleDependency.classifier());
                    return dependency;
                }

                public String getId() {
                    return null;
                }

                public Collection<DependencyModel> getDependencies() {
                    return null;
                }

                public String getSystemID() {
                    return null;
                }

                public String getVersion() {
                    return this.val$moduleDependency.version();
                }

                public URI getLocation() {
                    return null;
                }
            });
            if (!success) {
                throw new RuntimeException("Failed to add module dependencies");
            }
        });
        mutator.persist();
    }
}

