%dw 2.0
import * from scripts::modules::ScaffoldingModule
import alwaysAddProperty from scripts::modules::PropertiesModule

var unknown = {uri: "", prefix: ""} as Namespace

var unknownProducerConfig = "Unknown_Producer_configuration"
var unknownConsumerConfig = "Unknown_Consumer_configuration"

/**
* Returns basic property specifications
*/
fun getEnvironmentFile(apiPath) = [
  alwaysAddProperty("api.path", apiPath)
]

fun getNamespace(): Namespace = {}

fun getSchemaLocation(): Array<String> = []

fun scaffoldProducerConfig(existingConfiguration) = {}

fun scaffoldConsumerConfig(existingConfiguration, publishOp) = {}

fun scaffoldSubscribeFlow(existingConfiguration, flowName, subscribeOp) =
    scaffoldElement(
        (flow @("name": flowName): {
            logger @("level": "INFO", "message": "#[payload]"): {}
        }),
        lookupElementFromApp(
            existingConfiguration,
            (value, key, index) -> key ~= "flow" and value.@name == flowName
        )
    )

fun scaffoldPublishFlow(existingConfiguration, flowName, publishOp) = 
    scaffoldElement(
        (flow @("name": flowName): {
            logger @("level": "INFO", "message": "#[payload]"): {}
        }
        ),
        lookupElementFromApp(
            existingConfiguration,
            (value, key, index) -> key ~= "flow" and value.@name == flowName
        )
    )