%dw 2.0
import getExample from scripts::graphql::ExampleGeneration
import * from scripts::modules::ApiGraphModule
import * from scripts::modules::ScaffoldingModule
import every,firstWith from dw::core::Arrays
import toBoolean from dw::util::Coercions


fun generateProperty(property, depth, propertySchema,api) = do {
    var propertyType = getPropertyTypes(api,propertySchema)
    ---
    property match {
    case s if (isOfTypes(property,["raml-shapes:ScalarShape"])) -> (
        ((propertySchema)."shacl:name"):true
    )
    case s if (isOfTypes(property,["shacl:NodeShape"]) and depth>0 and not isOfTypes(propertyType,["raml-shapes:UnionShape"])) -> (
        (propertySchema."shacl:name"):
        getProperties(property,depth-1,api)
        
    )
    case s if (isOfTypes(property,["shacl:NodeShape"]) and (isOfTypes(propertyType,["raml-shapes:UnionShape"]) or property."raml-shapes:isAbstract" != null) and depth>0) -> (
        (propertySchema."shacl:name"):property."shacl:name"
    )
    else -> {}
}
}

fun getProperties(schema,depth,api) = 
    getPropertiesFromSchema(api, schema)
    flatMap ((propertySchema, index) -> getPropertyTypes(api,propertySchema)
        flatMap ((property, index) -> getPropertiesWithoutCompoundShape(property,api))
        flatMap ((propWithoutCompound, index) -> 
            generateProperty(propWithoutCompound,depth,propertySchema,api)))
    reduce (v, acc={}) -> v ++ acc

fun getPropertiesWithoutCompoundShape(property,api) =
    property match {
    case s if (isOfTypes(property,["raml-shapes:ArrayShape"]) or isOfTypes(property,["raml-shapes:UnionShape"]) or isOfTypes(property,["raml-shapes:RecursiveShape"])) -> (
        getNodeShapeFromCompoundShape(api, property)
    )
    else -> property
}

fun getResponseShape(operation,api) =
    getOperationResponse(api,operation)
    flatMap ((response, index)  -> getMessagePayloads(api, response))
    flatMap ((payload, index) -> getNonNilSchemasFromPayload(api,payload))
    flatMap ((shape, index) -> getNodeShapeFromCompoundShape(api, shape))
    flatMap ((schema, index) -> getProperties(schema,2,api))


fun getParametersShape(operation,api) =
    getOperationRequest(api,operation)
    flatMap ((request,index) -> getRequestParameters(api,request))
    map { name: $."core:name", shapeID: $."raml-shapes:schema"."@id" }

fun queries(api) = 
    getQueries(api)
    flatMap ((endpoint, index) -> getEndpointOperations(api, endpoint))
    flatMap ((operation, index) -> {
        fieldName: (operation."core:name" splitBy ".")[1],
        params: getParametersShape(operation, api),
        response: getResponseShape(operation, api) filter ($ != {})
    })
    
fun fromFragment(selectedFields) =
    selectedFields
    reduce (v, acc={}) ->
        acc ++ {
            (v.key):
                if (v.value is String)
                    true
                else
                    v.value
        }

// FIXME: Inner fields may allow parameterizations.
// Only top-level parameters are currently supported.
fun visitQuery(api, query, fieldName, params, ident=2, depth=0) = do {
    import repeat from dw::core::Strings

    var indentation = " " repeat (depth * ident)
    var nextIndentation = " " repeat ((depth + 1) * ident)

    var response = query

    var selectedScalars =
        entriesOf((response))
        filter $.value is true
        map $.key
    var scalars =
        if (isEmpty(selectedScalars))
            ""
        else
            "$(nextIndentation)$(selectedScalars joinBy '\n$(nextIndentation)')\n"

    var selectedObjects =
        entriesOf(response)
        filter $.value is Object
        map $.key
    var objects = selectedObjects map (visitQuery(api, query[$], $, [], ident, depth + 1)) joinBy ""

    var selectedFragments =
        entriesOf(response)
        filter $.value is String
        groupBy $.value
    var fragments =
        entriesOf(selectedFragments)
        map visitQuery(api, fromFragment($.value), "... on $($.key)", [], ident, depth + 1)
        joinBy ""

    var body = [scalars, objects, fragments] joinBy ""

    var arguments =
        params
        map getExample(api, $.shapeID)
    var argumentList =
        params.name
        // FIXME: We should probably roll our own serialization for input types.
        //        The fact that application/dw kinda works is nothing short of a miracle.
        map ("$($): $(write(arguments[$$], 'application/dw', { ignoreSchema: true }))")
        joinBy ", "
    
    ---
    if (not isEmpty(params))
        "{\n$(indentation)$(fieldName)($(argumentList)) {\n$(body)$(indentation)}\n}"
    else if (depth==0)
        ("{\n$(indentation)$(fieldName) {\n$(body)$(indentation)}\n}")
    else
        ("$(indentation)$(fieldName) {\n$(body)$(indentation)}\n")

}

fun getAllQueries(api) = 
     queries(api)
     flatMap ((query, index) -> do {
          visitQuery(api, query.response[0], query.fieldName, query.params)
     })

fun getQuery(fieldName, api) = do {
    (queries(api) filter ($.fieldName ~= fieldName))[0]
}

fun getQueryByOperationName(operationName, api) = do {
    var fieldName = (operationName splitBy  ".")[1]
    var query = getQuery(fieldName, api)
    ---
    visitQuery(api, query.response[0], fieldName, query.params)
}
