%dw 2.0
import * from scripts::modules::ApiGraphModule
import scripts::asyncapi::protocol::ProtocolAdapterModule
import getMuleNamespaces from scripts::modules::SharedComponentsModule

var unknownProtocol: String = "unknown"
var supportedProtocols: Array<String> = ["kafka"]

fun getParametersFromEndpoint(api, endpoint) =
    matchingObjectsById(getParameters(api),flattenIds(endpoint."apiContract:parameter"))
    flatMap ((parameter, index) -> parameter."core:name")

fun getOperations(api) =
    flatten(
        getEndpoints(api)
        map ((endpoint, index) ->
            getEndpointOperations(api, endpoint)
            map ((operation, index) ->
                {
                    opType: operation."apiContract:method",
                    channel: endpoint."apiContract:path",
                    parameters: getParametersFromEndpoint(api, endpoint)
                }
            )
        )
    )

fun getSubscribeOperations(api) = getOperations(api) filter ((item, index) ->  item.opType == "subscribe")

fun getPublishOperations(api) = getOperations(api) filter ((item, index) -> item.opType == "publish")

fun getServers(api) = api."@graph"
    filterTypes ["apiContract:AsyncAPI"]
    flatMap ((asyncApi, index) -> asyncApi."apiContract:server" default [])
    map ((item, index) ->
            item mapObject ((api."@graph" getObjectById $)[0]))

// FIXME: Considering first server only
fun getServerProtocolName(api): String = do {
    var servers = getServers(api)
    ---
    if (!isEmpty(servers))
        (
            supportedProtocols
            filter ((protocolName, index) -> servers[0]."apiContract:protocol" contains protocolName)
        )[0]
    else
        unknownProtocol
}

fun replaceInvalidCharacters(channelName) = channelName
    replace "{" with ("(")
    replace "}" with (")")
    replace "/" with ("\\")
    replace "[" with ("((")
    replace "]" with ("))")
    replace "#" with ("@")

fun getMuleNamespacesByApi(api) =
do {
    var serverProtocol = getServerProtocolName(api)
    var protocolNs = ProtocolAdapterModule::getNamespace(serverProtocol)
    var protocolSchemaLocation = ProtocolAdapterModule::getSchemaLocation(serverProtocol)
    ---
    getMuleNamespaces({(("xmlns:" ++ (protocolNs.prefix default "")): protocolNs.uri) if protocolNs != {}},protocolSchemaLocation)
}

fun getEnvironmentFile(protocol, apiPath) =
    ProtocolAdapterModule::getEnvironmentFile(protocol, apiPath)

fun scaffoldSubscribeFlow(serverProtocol, existingConfiguration, flowName, subscribeOp) =
    ProtocolAdapterModule::scaffoldSubscribeFlow(serverProtocol, existingConfiguration, flowName, subscribeOp)

fun scaffoldPublishFlow(serverProtocol, existingConfiguration, flowName, curatedChannelName, publishOp) =
    ProtocolAdapterModule::scaffoldPublishFlow(serverProtocol, existingConfiguration, flowName, curatedChannelName, publishOp)