%dw 2.0
import * from scripts::modules::ScaffoldingModule
import * from scripts::modules::PropertiesModule

ns kafka http://www.mulesoft.org/schema/mule/kafka

var kafkaProducerConfig = "Apache_Kafka_Producer_configuration"
var kafkaConsumerConfig = "Apache_Kafka_Consumer_configuration"

fun getNamespace(): Namespace = kafka

fun getSchemaLocation(): Array<String> = [kafka.uri ++ " http://www.mulesoft.org/schema/mule/kafka/current/mule-kafka.xsd"]

/**
* Returns property specifications for Kafka protocol
*/
fun getEnvironmentFile(apiPath) = [
  alwaysAddProperty("api.path", apiPath),
  addPropertyOnNewConfig("kafka.server.host", "localhost"),
  addPropertyOnNewConfig("kafka.server.port", "9092"),
]

fun getSetVariableElementsForOperation(operation) =
    operation.parameters
        flatMap ((parameter, index) ->
            ("set-variable" @("value": "TBD", "variableName": parameter): {})
        )

fun getTopicFromChannelName(operation) =
    if (!isEmpty(operation.parameters))
        (operation.parameters
        flatMap ((parameter, index) ->
            [
                '#["'
                ++ (operation.channel replace ("{$(parameter)}") with("\$(vars.$(parameter))"))
                ++ '"]'
            ]
        ))[0]
    else
        operation.channel

fun scaffoldProducerConfig(existingConfiguration) =
    scaffoldElement(
        (kafka#"producer-config" @("name": kafkaProducerConfig): {
            kafka#"producer-plaintext-connection": {
                kafka#"bootstrap-servers": {
                    kafka#"bootstrap-server" @(value: `\${kafka.server.host}:\${kafka.server.port}`): {}
                }
            }
        }),
        lookupElementFromApp(
            existingConfiguration,
            (value, key, index) -> key ~= "producer-config" and value.@name == kafkaProducerConfig
        )
    )

fun scaffoldConsumerConfig(existingConfiguration, curatedChannelName, publishOp) =
    scaffoldElement(
        (kafka#"consumer-config" @("name": kafkaConsumerConfig ++ "-" ++ curatedChannelName) : {
            kafka#"consumer-plaintext-connection": {
                kafka#"bootstrap-servers": {
                    kafka#"bootstrap-server" @(value: `\${kafka.server.host}:\${kafka.server.port}`): {}
                },
                kafka#"topic-patterns": {
                    kafka#"topic-pattern" @(value: curatedChannelName): {}
                }
            }
        }),
        lookupElementFromApp(
            existingConfiguration,
            (value, key, index) -> key ~= "consumer-config" and value.@name == (kafkaConsumerConfig ++ "-" ++ curatedChannelName)
        )
    )

fun scaffoldSubscribeFlow(existingConfiguration, flowName, subscribeOp) =
    scaffoldElement(
        (flow @("name": flowName): {
            (getSetVariableElementsForOperation(subscribeOp)),
            kafka#publish @("config-ref": kafkaProducerConfig, "topic": getTopicFromChannelName(subscribeOp)): {}
        }),
        lookupElementFromApp(
            existingConfiguration,
            (value, key, index) -> key ~= "flow" and value.@name == flowName
        )
    )

fun scaffoldPublishFlow(existingConfiguration, flowName, curatedChannelName, publishOp) =
    scaffoldElement(
        (flow @("name": flowName): {
            kafka#"message-listener" @("config-ref": kafkaConsumerConfig ++ "-" ++ curatedChannelName): {},
            logger @("level": "INFO", "message": "#[payload]"): {}
        }
        ),
        lookupElementFromApp(
            existingConfiguration,
            (value, key, index) -> key ~= "flow" and value.@name == flowName
        )
    )