%dw 2.0
import scripts::asyncapi::protocol::KafkaModule
import scripts::asyncapi::protocol::UnknownModule

fun scaffoldProducerConfig(protocol, existingConfiguration) = 
    protocol match {
            case name if (name contains "kafka") -> KafkaModule::scaffoldProducerConfig(existingConfiguration)
            else -> UnknownModule::scaffoldProducerConfig(existingConfiguration)
        }

fun scaffoldConsumerConfig(protocol, existingConfiguration, curatedChannelName, operation) =
    protocol match {
                case name if (name contains "kafka") -> KafkaModule::scaffoldConsumerConfig(existingConfiguration,curatedChannelName,operation)
                else -> UnknownModule::scaffoldConsumerConfig(existingConfiguration,operation)
            }



fun scaffoldSubscribeFlow(protocol, existingConfiguration, flowName, operation) = 
    protocol match {
            case name if (name contains "kafka") -> KafkaModule::scaffoldSubscribeFlow(existingConfiguration,flowName,operation)
            else -> UnknownModule::scaffoldSubscribeFlow(existingConfiguration,flowName,operation)
        }

fun scaffoldPublishFlow(protocol, existingConfiguration, flowName, curatedChannelName, operation) =
    protocol match {
            case name if (name contains "kafka") -> KafkaModule::scaffoldPublishFlow(existingConfiguration,flowName,curatedChannelName,operation)
            else -> UnknownModule::scaffoldPublishFlow(existingConfiguration,flowName,operation)
        }

fun getNamespace(protocol): Namespace =
    protocol match {
        case name if (name contains "kafka") -> KafkaModule::getNamespace()
        else -> UnknownModule::getNamespace()
    }

fun getSchemaLocation(protocol): Array<String> =
    protocol match {
        case name if (name contains "kafka") -> KafkaModule::getSchemaLocation()
        else -> UnknownModule::getSchemaLocation()
    }

fun getEnvironmentFile(protocol, apiPath) =
    protocol match {
        case name if (name contains "kafka") -> KafkaModule::getEnvironmentFile(apiPath)
        else -> UnknownModule::getEnvironmentFile(apiPath)
    }