%dw 2.0
import every,firstWith from dw::core::Arrays
import toBoolean from dw::util::Coercions
import * from scripts::modules::ScaffoldingModule
import * from scripts::asyncapi::AsyncApiModule
import * from scripts::modules::SharedComponentsModule
import scaffoldProducerConfig, scaffoldConsumerConfig from scripts::asyncapi::protocol::ProtocolAdapterModule

input api application/json
input existingConfiguration application/xml
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core"

var serverProtocol = getServerProtocolName(api)
---
mule @((getMuleNamespacesByApi(api))): {
    (
        if (!isEmpty(getSubscribeOperations(api))) (
            scaffoldProducerConfig(serverProtocol, existingConfiguration)
         ) else {}
    ),
    (
        getPublishOperations(api) map ((publishOp, index) ->
            do {
                var curatedChannelName = replaceInvalidCharacters(publishOp.channel)
                ---
                scaffoldConsumerConfig(serverProtocol, existingConfiguration, curatedChannelName, publishOp)
            }
        )
    ),
    (
        scaffoldGlobalConfigurationProperties(existingConfiguration)
    ),
    (
        scaffoldGlobalProperties(existingConfiguration)
    )

}
