%dw 2.0
import mergeWith from dw::core::Objects
import scripts::asyncapi::AsyncApiModule
import scripts::graphql::GraphqlModule
import * from scripts::modules::PropertiesModule

input api application/json
input apiPath text/plain
input propertyFiles application/java
output application/java

var classifier = (apiPath splitBy ":")[5]

var serverProtocol =
        if (classifier contains "asyncapi")
            AsyncApiModule::getServerProtocolName(api)
        else
            classifier

var environmentFile =
    serverProtocol match {
        case protocol if (protocol contains "graphql") ->
            GraphqlModule::getEnvironmentFile(apiPath)
        else -> (
            if (classifier contains "asyncapi")
                AsyncApiModule::getEnvironmentFile(serverProtocol,apiPath)
            else
                []
        )
    }
---
getParsedEnvironmentFiles(propertyFiles)
    mapValues addRequiredProperties($, environmentFile)
    mapValues write($, 'text/x-java-properties')