%dw 2.0
import * from scripts::asyncapi::AsyncApiModule
import getSchemaLocations from scripts::asyncapi::protocol::ProtocolAdapterModule

input api application/json
input existingConfiguration application/xml
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core", inlineCloseOn="null"

var protocols = getProtocols(api)
var schemas = [getAsyncApiSchemaLocation()] ++ getSchemaLocations(protocols)
var publishOps = getPublishOpTypes(api)
var servers = getServers(api)
---
mule @((getMuleNamespacesByProtocolSchemas(schemas))): {
    (
        publishOps map ((publishOp, index) ->
            scaffoldAsyncApiSubscribeFlow(api, existingConfiguration, servers, publishOp)
        )
    )
}
