%dw 2.0
import fail from dw::Runtime
import scripts::asyncapi::protocol::KafkaModule
import scripts::asyncapi::protocol::AnypointMQModule
import * from scripts::modules::PropertiesModule

var protocolOrder = {
    "kafka": 0,
    "anypointmq": 1
}

fun scaffoldAsyncApiConfigs(api, protocols: Array<String>) =
    protocols orderBy protocolOrder[$] map (
        $ match  {
            case name if (name contains "kafka") -> KafkaModule::scaffoldAsyncApiConfig(api)
            case name if (name contains "anypointmq") -> AnypointMQModule::scaffoldAsyncApiConfig(api)
            else -> fail('Unsupported protocol: ' ++ $)
        }
    )

fun scaffoldProtocolConfigs(api, protocols: Array<String>, existingConfiguration) =
    protocols orderBy protocolOrder[$] map (
        $ match {
                case name if (name contains "kafka") ->
                    KafkaModule::scaffoldConfigs(api, existingConfiguration)
                case name if (name contains "anypointmq") ->
                    AnypointMQModule::scaffoldConfigs(api, existingConfiguration)
                else -> fail('Unsupported protocol: ' ++ $)
        }
    )

/*
 * Given an array of protocol names, return an array of
 * corresponding schema locations.
 */
fun getSchemaLocations(protocols: Array<String>): Array<String> =
    protocols orderBy protocolOrder[$] map (
        $ match {
            case name if (name contains "kafka") -> KafkaModule::getSchemaLocation()
            case name if (name contains "anypointmq") -> AnypointMQModule::getSchemaLocation()
            else -> fail('Unsupported protocol: ' ++ $)
        }
    )

fun getEnvironmentFile(api, protocols, apiPath) =
    protocols orderBy protocolOrder[$] reduce ((protocol, acc = []) ->
        protocol match {
            case name if (name contains "kafka") -> acc ++ KafkaModule::getEnvironmentFile(api, apiPath)
            case name if (name contains "anypointmq") -> acc ++ AnypointMQModule::getEnvironmentFile(api, apiPath)
            else -> fail('Unsupported protocol: ' ++ $)
        }
    )
