/*
 * Decompiled with CFR 0.152.
 */
package amf.xml.internal.util;

import java.util.concurrent.Callable;

public class ClassLoadingUtils {
    public static <T> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable) {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        if (currentClassLoader != classLoader) {
            thread.setContextClassLoader(classLoader);
        }
        try {
            T t2 = callable.call();
            return t2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (currentClassLoader != classLoader) {
                thread.setContextClassLoader(currentClassLoader);
            }
        }
    }
}

