/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WNameFactory;
import com.fasterxml.aalto.util.NameTable;
import javax.xml.stream.XMLStreamException;

public final class WNameTable
extends NameTable {
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    final WNameFactory mNameFactory;
    final WNameTable mParent;
    private int mCount;
    private int mMainHashMask;
    private int[] mMainHash;
    private WName[] mMainNames;
    private Bucket[] mCollList;
    private int mCollCount;
    private int mCollEnd;
    private transient boolean mNeedRehash;
    private boolean mMainHashShared;
    private boolean mMainNamesShared;
    private boolean mCollListShared;

    protected WNameTable(int hashSize) {
        this.mNameFactory = null;
        this.mParent = null;
        if (hashSize < 16) {
            hashSize = 16;
        } else if ((hashSize & hashSize - 1) != 0) {
            int curr;
            for (curr = 16; curr < hashSize; curr += curr) {
            }
            hashSize = curr;
        }
        this.mCount = 0;
        this.mMainHashShared = false;
        this.mMainNamesShared = false;
        this.mMainHashMask = hashSize - 1;
        this.mMainHash = new int[hashSize];
        this.mMainNames = new WName[hashSize];
        this.mCollListShared = true;
        this.mCollList = null;
        this.mCollEnd = 0;
        this.mNeedRehash = false;
    }

    private WNameTable(WNameTable parent, WNameFactory f) {
        this.mParent = parent;
        this.mNameFactory = f;
        this.mCount = parent.mCount;
        this.mMainHashMask = parent.mMainHashMask;
        this.mMainHash = parent.mMainHash;
        this.mMainNames = parent.mMainNames;
        this.mCollList = parent.mCollList;
        this.mCollCount = parent.mCollCount;
        this.mCollEnd = parent.mCollEnd;
        this.mNeedRehash = false;
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    protected synchronized WNameTable createChild(WNameFactory f) {
        return new WNameTable(this, f);
    }

    public boolean mergeToParent() {
        boolean changed = this.mParent.mergeFromChild(this);
        this.markAsShared();
        return changed;
    }

    private synchronized boolean mergeFromChild(WNameTable child) {
        if (child.mCount <= this.mCount) {
            return false;
        }
        this.mCount = child.mCount;
        this.mMainHashMask = child.mMainHashMask;
        this.mMainHash = child.mMainHash;
        this.mMainNames = child.mMainNames;
        this.mCollList = child.mCollList;
        this.mCollCount = child.mCollCount;
        this.mCollEnd = child.mCollEnd;
        return true;
    }

    public void markAsShared() {
        this.mMainHashShared = true;
        this.mMainNamesShared = true;
        this.mCollListShared = true;
    }

    public void nuke() {
        this.mMainHash = null;
        this.mMainNames = null;
        this.mCollList = null;
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean maybeDirty() {
        return !this.mMainHashShared;
    }

    public WName findSymbol(String localName) throws XMLStreamException {
        WName name;
        Bucket bucket;
        WName wname;
        int hash = localName.hashCode();
        int ix = hash & this.mMainHashMask;
        int val2 = this.mMainHash[ix];
        if ((val2 >> 8 ^ hash) << 8 == 0 && (wname = this.mMainNames[ix]) != null && wname.hasName(localName)) {
            return wname;
        }
        if (val2 != 0 && (val2 &= 0xFF) > 0 && (bucket = this.mCollList[--val2]) != null && (name = bucket.find(localName)) != null) {
            return name;
        }
        WName name2 = this.mNameFactory.constructName(localName);
        this.addSymbol(name2);
        return name2;
    }

    public WName findSymbol(String prefix, String localName) throws XMLStreamException {
        WName name;
        Bucket bucket;
        WName wname;
        int hash = localName.hashCode() ^ prefix.hashCode();
        int ix = hash & this.mMainHashMask;
        int val2 = this.mMainHash[ix];
        if ((val2 >> 8 ^ hash) << 8 == 0 && (wname = this.mMainNames[ix]) != null && wname.hasName(prefix, localName)) {
            return wname;
        }
        if (val2 != 0 && (val2 &= 0xFF) > 0 && (bucket = this.mCollList[--val2]) != null && (name = bucket.find(prefix, localName)) != null) {
            return name;
        }
        WName name2 = this.mNameFactory.constructName(prefix, localName);
        this.addSymbol(name2);
        return name2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[WNameTable, size: ");
        sb.append(this.mCount);
        sb.append('/');
        sb.append(this.mMainHash.length);
        sb.append(", ");
        sb.append(this.mCollCount);
        sb.append(" coll; avg length: ");
        int pathCount = this.mCount;
        for (int i = 0; i < this.mCollEnd; ++i) {
            int spillLen = this.mCollList[i].length();
            for (int j = 1; j <= spillLen; ++j) {
                pathCount += j;
            }
        }
        double avgLength = this.mCount == 0 ? 0.0 : (double)pathCount / (double)this.mCount;
        sb.append(avgLength);
        sb.append(']');
        return sb.toString();
    }

    public String toDebugString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("[WNameTable, size: ");
        sb.append(this.mCount);
        sb.append('/');
        sb.append(this.mMainHash.length);
        sb.append(" -> ");
        for (i = 0; i < this.mMainHash.length; ++i) {
            sb.append("\n#");
            sb.append(i);
            sb.append(": 0x");
            sb.append(Integer.toHexString(this.mMainHash[i]));
            sb.append(" == ");
            WName name = this.mMainNames[i];
            if (name == null) {
                sb.append("null");
                continue;
            }
            sb.append('\"');
            sb.append(name.toString());
            sb.append('\"');
        }
        sb.append("\nSpill(");
        sb.append(this.mCollEnd);
        sb.append("):");
        for (i = 0; i < this.mCollEnd; ++i) {
            Bucket bucket = this.mCollList[i];
            sb.append("\nsp#");
            sb.append(i);
            sb.append(": ");
            sb.append(bucket.toDebugString());
        }
        return sb.toString();
    }

    private void addSymbol(WName symbol2) {
        if (this.mMainHashShared) {
            this.unshareMain();
        }
        if (this.mNeedRehash) {
            this.rehash();
        }
        int hash = symbol2.hashCode();
        ++this.mCount;
        int ix = hash & this.mMainHashMask;
        if (this.mMainNames[ix] == null) {
            this.mMainHash[ix] = hash << 8;
            if (this.mMainNamesShared) {
                this.unshareNames();
            }
            this.mMainNames[ix] = symbol2;
        } else {
            if (this.mCollListShared) {
                this.unshareCollision();
            }
            ++this.mCollCount;
            int entryValue = this.mMainHash[ix];
            int bucket = entryValue & 0xFF;
            if (bucket == 0) {
                if (this.mCollEnd <= 254) {
                    if ((bucket = this.mCollEnd++) >= this.mCollList.length) {
                        this.expandCollision();
                    }
                } else {
                    bucket = this.findBestBucket();
                }
                this.mMainHash[ix] = entryValue & 0xFFFFFF00 | bucket + 1;
            } else {
                --bucket;
            }
            this.mCollList[bucket] = new Bucket(symbol2, this.mCollList[bucket]);
        }
        int hashSize = this.mMainHash.length;
        if (this.mCount > hashSize >> 1) {
            int hashQuarter = hashSize >> 2;
            if (this.mCount > hashSize - hashQuarter) {
                this.mNeedRehash = true;
            } else if (this.mCollCount >= hashQuarter) {
                this.mNeedRehash = true;
            }
        }
    }

    private void rehash() {
        this.mNeedRehash = false;
        this.mMainNamesShared = false;
        int symbolsSeen = 0;
        int[] oldMainHash = this.mMainHash;
        int len = oldMainHash.length;
        this.mMainHash = new int[len + len];
        this.mMainHashMask = len + len - 1;
        WName[] oldNames = this.mMainNames;
        this.mMainNames = new WName[len + len];
        for (int i = 0; i < len; ++i) {
            WName symbol2 = oldNames[i];
            if (symbol2 == null) continue;
            ++symbolsSeen;
            int hash = symbol2.hashCode();
            int ix = hash & this.mMainHashMask;
            this.mMainNames[ix] = symbol2;
            this.mMainHash[ix] = hash << 8;
        }
        int oldEnd = this.mCollEnd;
        if (oldEnd == 0) {
            return;
        }
        this.mCollCount = 0;
        this.mCollEnd = 0;
        this.mCollListShared = false;
        Bucket[] oldBuckets = this.mCollList;
        this.mCollList = new Bucket[oldBuckets.length];
        for (int i = 0; i < oldEnd; ++i) {
            Bucket curr = oldBuckets[i];
            while (curr != null) {
                ++symbolsSeen;
                WName symbol3 = curr.mName;
                int hash = symbol3.hashCode();
                int ix = hash & this.mMainHashMask;
                int val2 = this.mMainHash[ix];
                if (this.mMainNames[ix] == null) {
                    this.mMainHash[ix] = hash << 8;
                    this.mMainNames[ix] = symbol3;
                } else {
                    ++this.mCollCount;
                    int bucket = val2 & 0xFF;
                    if (bucket == 0) {
                        if (this.mCollEnd <= 254) {
                            if ((bucket = this.mCollEnd++) >= this.mCollList.length) {
                                this.expandCollision();
                            }
                        } else {
                            bucket = this.findBestBucket();
                        }
                        this.mMainHash[ix] = val2 & 0xFFFFFF00 | bucket + 1;
                    } else {
                        --bucket;
                    }
                    this.mCollList[bucket] = new Bucket(symbol3, this.mCollList[bucket]);
                }
                curr = curr.mNext;
            }
        }
        if (symbolsSeen != this.mCount) {
            throw new Error("Internal error: count after rehash " + symbolsSeen + "; should be " + this.mCount);
        }
    }

    private int findBestBucket() {
        Bucket[] buckets = this.mCollList;
        int bestCount = Integer.MAX_VALUE;
        int bestIx = -1;
        int len = this.mCollEnd;
        for (int i = 0; i < len; ++i) {
            int count = buckets[i].length();
            if (count >= bestCount) continue;
            if (count == 1) {
                return i;
            }
            bestCount = count;
            bestIx = i;
        }
        return bestIx;
    }

    private void unshareMain() {
        int[] old = this.mMainHash;
        int len = this.mMainHash.length;
        this.mMainHash = new int[len];
        System.arraycopy(old, 0, this.mMainHash, 0, len);
        this.mMainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] old = this.mCollList;
        if (old == null) {
            this.mCollList = new Bucket[32];
        } else {
            int len = old.length;
            this.mCollList = new Bucket[len];
            System.arraycopy(old, 0, this.mCollList, 0, len);
        }
        this.mCollListShared = false;
    }

    private void unshareNames() {
        WName[] old = this.mMainNames;
        int len = old.length;
        this.mMainNames = new WName[len];
        System.arraycopy(old, 0, this.mMainNames, 0, len);
        this.mMainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] old = this.mCollList;
        int len = old.length;
        this.mCollList = new Bucket[len + len];
        System.arraycopy(old, 0, this.mCollList, 0, len);
    }

    static final class Bucket {
        final WName mName;
        final Bucket mNext;

        Bucket(WName name, Bucket next) {
            this.mName = name;
            this.mNext = next;
        }

        public int length() {
            int len = 1;
            Bucket curr = this.mNext;
            while (curr != null) {
                ++len;
                curr = curr.mNext;
            }
            return len;
        }

        public WName find(String localName) {
            if (this.mName.hasName(localName)) {
                return this.mName;
            }
            Bucket curr = this.mNext;
            while (curr != null) {
                WName currName = curr.mName;
                if (currName.hasName(localName)) {
                    return currName;
                }
                curr = curr.mNext;
            }
            return null;
        }

        public WName find(String prefix, String localName) {
            if (this.mName.hasName(prefix, localName)) {
                return this.mName;
            }
            Bucket curr = this.mNext;
            while (curr != null) {
                WName currName = curr.mName;
                if (currName.hasName(prefix, localName)) {
                    return currName;
                }
                curr = curr.mNext;
            }
            return null;
        }

        public String toDebugString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[Bucket(");
            sb.append(this.length());
            sb.append("): ");
            Bucket curr = this;
            while (curr != null) {
                sb.append('\"');
                sb.append(curr.mName.toString());
                sb.append("\" -> ");
                curr = curr.mNext;
            }
            sb.append("NULL]");
            return sb.toString();
        }
    }
}

