/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.helpers.DraftV3TypeKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Iterator;

public final class DraftV3TypeValidator
extends DraftV3TypeKeywordValidator {
    public DraftV3TypeValidator(JsonNode digest) {
        super("type", digest);
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle2, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        NodeType type = NodeType.getNodeType(instance);
        boolean primitiveOK = this.types.contains((Object)type);
        if (primitiveOK) {
            return;
        }
        ObjectNode fullReport = FACTORY.objectNode();
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        int nrSuccess = 0;
        Iterator iterator = this.schemas.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of(this.keyword, index));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process(subReport, newData);
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess >= 1) {
            return;
        }
        if (!this.types.isEmpty()) {
            report.error(this.newMsg(data, bundle2, "err.common.typeNoMatch").putArgument("found", type).putArgument("expected", DraftV3TypeValidator.toArrayNode(this.types)));
        }
        if (!this.schemas.isEmpty()) {
            report.error(this.newMsg(data, bundle2, "err.common.schema.noMatch").putArgument("nrSchemas", this.schemas.size()).put("reports", fullReport));
        }
    }
}

