/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util.logging;

import com.sun.mail.util.logging.LogManagerProperties;
import com.sun.mail.util.logging.SeverityComparator;
import java.util.Date;
import java.util.Formattable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class CompactFormatter
extends Formatter {
    private final String fmt;

    private static Class<?>[] loadDeclaredClasses() {
        return new Class[]{Alternate.class};
    }

    public CompactFormatter() {
        String p = this.getClass().getName();
        this.fmt = this.initFormat(p);
    }

    public CompactFormatter(String format) {
        String p = this.getClass().getName();
        this.fmt = format == null ? this.initFormat(p) : format;
    }

    @Override
    public String format(LogRecord record2) {
        ResourceBundle rb = record2.getResourceBundle();
        Locale l = rb == null ? null : rb.getLocale();
        String msg = this.formatMessage(record2);
        String thrown = this.formatThrown(record2);
        String err = this.formatError(record2);
        Object[] params = new Object[]{this.formatZonedDateTime(record2), this.formatSource(record2), this.formatLoggerName(record2), this.formatLevel(record2), msg, thrown, new Alternate(msg, thrown), new Alternate(thrown, msg), record2.getSequenceNumber(), this.formatThreadID(record2), err, new Alternate(msg, err), new Alternate(err, msg), this.formatBackTrace(record2), record2.getResourceBundleName(), record2.getMessage()};
        if (l == null) {
            return String.format(this.fmt, params);
        }
        return String.format(l, this.fmt, params);
    }

    @Override
    public String formatMessage(LogRecord record2) {
        String msg = super.formatMessage(record2);
        msg = CompactFormatter.replaceClassName(msg, record2.getThrown());
        msg = CompactFormatter.replaceClassName(msg, record2.getParameters());
        return msg;
    }

    public String formatMessage(Throwable t2) {
        String r;
        if (t2 != null) {
            Throwable apply2 = this.apply(t2);
            String m4 = apply2.getLocalizedMessage();
            String s2 = apply2.toString();
            String sn = CompactFormatter.simpleClassName(apply2.getClass());
            r = !CompactFormatter.isNullOrSpaces(m4) ? (s2.contains(m4) ? (s2.startsWith(apply2.getClass().getName()) || s2.startsWith(sn) ? CompactFormatter.replaceClassName(m4, t2) : CompactFormatter.replaceClassName(CompactFormatter.simpleClassName(s2), t2)) : CompactFormatter.replaceClassName(CompactFormatter.simpleClassName(s2) + ": " + m4, t2)) : CompactFormatter.replaceClassName(CompactFormatter.simpleClassName(s2), t2);
            if (!r.contains(sn)) {
                r = sn + ": " + r;
            }
        } else {
            r = "";
        }
        return r;
    }

    public String formatLevel(LogRecord record2) {
        return record2.getLevel().getLocalizedName();
    }

    public String formatSource(LogRecord record2) {
        String source = record2.getSourceClassName();
        source = source != null ? (record2.getSourceMethodName() != null ? CompactFormatter.simpleClassName(source) + " " + record2.getSourceMethodName() : CompactFormatter.simpleClassName(source)) : CompactFormatter.simpleClassName(record2.getLoggerName());
        return source;
    }

    public String formatLoggerName(LogRecord record2) {
        return CompactFormatter.simpleClassName(record2.getLoggerName());
    }

    public Number formatThreadID(LogRecord record2) {
        Long id = LogManagerProperties.getLongThreadID(record2);
        if (id == null) {
            id = (long)record2.getThreadID() & 0xFFFFFFFFL;
        }
        return id;
    }

    public String formatThrown(LogRecord record2) {
        String msg;
        Throwable t2 = record2.getThrown();
        if (t2 != null) {
            String site = this.formatBackTrace(record2);
            msg = this.formatMessage(t2) + (CompactFormatter.isNullOrSpaces(site) ? "" : ' ' + site);
        } else {
            msg = "";
        }
        return msg;
    }

    public String formatError(LogRecord record2) {
        return this.formatMessage(record2.getThrown());
    }

    public String formatBackTrace(LogRecord record2) {
        Throwable root;
        StackTraceElement[] trace;
        String site = "";
        Throwable t2 = record2.getThrown();
        if (t2 != null && CompactFormatter.isNullOrSpaces(site = this.findAndFormat(trace = (root = this.apply(t2)).getStackTrace()))) {
            StackTraceElement[] ste;
            int limit = 0;
            for (Throwable c = t2; c != null && CompactFormatter.isNullOrSpaces(site = this.findAndFormat(ste = c.getStackTrace())); c = c.getCause()) {
                if (trace.length == 0) {
                    trace = ste;
                }
                if (++limit == 65536) break;
            }
            if (CompactFormatter.isNullOrSpaces(site) && trace.length != 0) {
                site = this.formatStackTraceElement(trace[0]);
            }
        }
        return site;
    }

    private String findAndFormat(StackTraceElement[] trace) {
        String site = "";
        for (StackTraceElement s2 : trace) {
            if (this.ignore(s2)) continue;
            site = this.formatStackTraceElement(s2);
            break;
        }
        if (CompactFormatter.isNullOrSpaces(site)) {
            for (StackTraceElement s2 : trace) {
                if (this.defaultIgnore(s2)) continue;
                site = this.formatStackTraceElement(s2);
                break;
            }
        }
        return site;
    }

    private String formatStackTraceElement(StackTraceElement s2) {
        String v = CompactFormatter.simpleClassName(s2.getClassName());
        String result = s2.toString().replace(s2.getClassName(), v);
        v = CompactFormatter.simpleFileName(s2.getFileName());
        if (v != null && result.startsWith(v)) {
            result = result.replace(s2.getFileName(), "");
        }
        return result;
    }

    protected Throwable apply(Throwable t2) {
        return SeverityComparator.getInstance().apply(t2);
    }

    protected boolean ignore(StackTraceElement s2) {
        return this.isUnknown(s2) || this.defaultIgnore(s2);
    }

    protected String toAlternate(String s2) {
        return s2 != null ? s2.replaceAll("[\\x00-\\x1F\\x7F]+", "") : null;
    }

    private Comparable<?> formatZonedDateTime(LogRecord record2) {
        Date zdt = LogManagerProperties.getZonedDateTime(record2);
        if (zdt == null) {
            zdt = new Date(record2.getMillis());
        }
        return zdt;
    }

    private boolean defaultIgnore(StackTraceElement s2) {
        return this.isSynthetic(s2) || this.isStaticUtility(s2) || this.isReflection(s2);
    }

    private boolean isStaticUtility(StackTraceElement s2) {
        try {
            return LogManagerProperties.isStaticUtilityClass(s2.getClassName());
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
        String cn = s2.getClassName();
        return cn.endsWith("s") && !cn.endsWith("es") || cn.contains("Util") || cn.endsWith("Throwables");
    }

    private boolean isSynthetic(StackTraceElement s2) {
        return s2.getMethodName().indexOf(36) > -1;
    }

    private boolean isUnknown(StackTraceElement s2) {
        return s2.getLineNumber() < 0;
    }

    private boolean isReflection(StackTraceElement s2) {
        try {
            return LogManagerProperties.isReflectionClass(s2.getClassName());
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
        return s2.getClassName().startsWith("java.lang.reflect.") || s2.getClassName().startsWith("sun.reflect.");
    }

    private String initFormat(String p) {
        String v = LogManagerProperties.fromLogManager(p.concat(".format"));
        if (CompactFormatter.isNullOrSpaces(v)) {
            v = "%7$#.160s%n";
        }
        return v;
    }

    private static String replaceClassName(String msg, Throwable t2) {
        if (!CompactFormatter.isNullOrSpaces(msg)) {
            int limit = 0;
            for (Throwable c = t2; c != null; c = c.getCause()) {
                Class<?> k = c.getClass();
                msg = msg.replace(k.getName(), CompactFormatter.simpleClassName(k));
                if (++limit == 65536) break;
            }
        }
        return msg;
    }

    private static String replaceClassName(String msg, Object[] p) {
        if (!CompactFormatter.isNullOrSpaces(msg) && p != null) {
            for (Object o : p) {
                if (o == null) continue;
                Class<?> k = o.getClass();
                msg = msg.replace(k.getName(), CompactFormatter.simpleClassName(k));
            }
        }
        return msg;
    }

    private static String simpleClassName(Class<?> k) {
        try {
            return k.getSimpleName();
        }
        catch (InternalError internalError) {
            return CompactFormatter.simpleClassName(k.getName());
        }
    }

    private static String simpleClassName(String name) {
        if (name != null) {
            int cursor;
            int c;
            int dot;
            int sign = -1;
            int prev = dot = -1;
            for (cursor = 0; cursor < name.length(); cursor += Character.charCount(c)) {
                c = name.codePointAt(cursor);
                if (!Character.isJavaIdentifierPart(c)) {
                    if (c == 46) {
                        if (dot + 1 != cursor && dot + 1 != sign) {
                            prev = dot;
                            dot = cursor;
                            continue;
                        }
                        return name;
                    }
                    if (dot + 1 != cursor) break;
                    dot = prev;
                    break;
                }
                if (c != 36) continue;
                sign = cursor;
            }
            if (dot > -1 && ++dot < cursor && ++sign < cursor) {
                name = name.substring(sign > dot ? sign : dot);
            }
        }
        return name;
    }

    private static String simpleFileName(String name) {
        if (name != null) {
            int index = name.lastIndexOf(46);
            name = index > -1 ? name.substring(0, index) : name;
        }
        return name;
    }

    private static boolean isNullOrSpaces(String s2) {
        return s2 == null || s2.trim().isEmpty();
    }

    static {
        CompactFormatter.loadDeclaredClasses();
    }

    private class Alternate
    implements Formattable {
        private final String left;
        private final String right;

        Alternate(String left, String right) {
            this.left = String.valueOf(left);
            this.right = String.valueOf(right);
        }

        @Override
        public void formatTo(java.util.Formatter formatter, int flags, int width, int precision) {
            String l = this.left;
            String r = this.right;
            if ((flags & 2) == 2) {
                l = l.toUpperCase(formatter.locale());
                r = r.toUpperCase(formatter.locale());
            }
            if ((flags & 4) == 4) {
                l = CompactFormatter.this.toAlternate(l);
                r = CompactFormatter.this.toAlternate(r);
            }
            int lc = 0;
            int rc = 0;
            if (precision >= 0) {
                lc = this.minCodePointCount(l, precision);
                rc = this.minCodePointCount(r, precision);
                if (lc > precision >> 1) {
                    lc = Math.max(lc - rc, lc >> 1);
                }
                rc = Math.min(precision - lc, rc);
                l = l.substring(0, l.offsetByCodePoints(0, lc));
                r = r.substring(0, r.offsetByCodePoints(0, rc));
            }
            if (width > 0) {
                int half;
                if (precision < 0) {
                    lc = this.minCodePointCount(l, width);
                    rc = this.minCodePointCount(r, width);
                }
                if (lc < (half = width >> 1)) {
                    l = this.pad(flags, l, half - lc);
                }
                if (rc < half) {
                    r = this.pad(flags, r, half - rc);
                }
            }
            formatter.format(l, new Object[0]);
            if (!l.isEmpty() && !r.isEmpty()) {
                formatter.format("|", new Object[0]);
            }
            formatter.format(r, new Object[0]);
        }

        private int minCodePointCount(String s2, int limit) {
            int len = s2.length();
            if (len - limit >= limit) {
                return limit;
            }
            return Math.min(s2.codePointCount(0, len), limit);
        }

        private String pad(int flags, String s2, int padding) {
            StringBuilder b = new StringBuilder(Math.max(s2.length() + padding, padding));
            if ((flags & 1) == 1) {
                for (int i = 0; i < padding; ++i) {
                    b.append(' ');
                }
                b.append(s2);
            } else {
                b.append(s2);
                for (int i = 0; i < padding; ++i) {
                    b.append(' ');
                }
            }
            return b.toString();
        }
    }
}

