/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverterImpl;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBPermission;
import javax.xml.bind.Messages;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public final class DatatypeConverter {
    private static volatile DatatypeConverterInterface theConverter = null;
    private static final JAXBPermission SET_DATATYPE_CONVERTER_PERMISSION = new JAXBPermission("setDatatypeConverter");

    private DatatypeConverter() {
    }

    public static void setDatatypeConverter(DatatypeConverterInterface converter) {
        if (converter == null) {
            throw new IllegalArgumentException(Messages.format("DatatypeConverter.ConverterMustNotBeNull"));
        }
        if (theConverter == null) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(SET_DATATYPE_CONVERTER_PERMISSION);
            }
            theConverter = converter;
        }
    }

    private static synchronized void initConverter() {
        theConverter = new DatatypeConverterImpl();
    }

    public static String parseString(String lexicalXSDString) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseString(lexicalXSDString);
    }

    public static BigInteger parseInteger(String lexicalXSDInteger) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseInteger(lexicalXSDInteger);
    }

    public static int parseInt(String lexicalXSDInt) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseInt(lexicalXSDInt);
    }

    public static long parseLong(String lexicalXSDLong) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseLong(lexicalXSDLong);
    }

    public static short parseShort(String lexicalXSDShort) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseShort(lexicalXSDShort);
    }

    public static BigDecimal parseDecimal(String lexicalXSDDecimal) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseDecimal(lexicalXSDDecimal);
    }

    public static float parseFloat(String lexicalXSDFloat) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseFloat(lexicalXSDFloat);
    }

    public static double parseDouble(String lexicalXSDDouble) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseDouble(lexicalXSDDouble);
    }

    public static boolean parseBoolean(String lexicalXSDBoolean) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseBoolean(lexicalXSDBoolean);
    }

    public static byte parseByte(String lexicalXSDByte) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseByte(lexicalXSDByte);
    }

    public static QName parseQName(String lexicalXSDQName, NamespaceContext nsc) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseQName(lexicalXSDQName, nsc);
    }

    public static Calendar parseDateTime(String lexicalXSDDateTime) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseDateTime(lexicalXSDDateTime);
    }

    public static byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseBase64Binary(lexicalXSDBase64Binary);
    }

    public static byte[] parseHexBinary(String lexicalXSDHexBinary) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseHexBinary(lexicalXSDHexBinary);
    }

    public static long parseUnsignedInt(String lexicalXSDUnsignedInt) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseUnsignedInt(lexicalXSDUnsignedInt);
    }

    public static int parseUnsignedShort(String lexicalXSDUnsignedShort) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseUnsignedShort(lexicalXSDUnsignedShort);
    }

    public static Calendar parseTime(String lexicalXSDTime) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseTime(lexicalXSDTime);
    }

    public static Calendar parseDate(String lexicalXSDDate) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseDate(lexicalXSDDate);
    }

    public static String parseAnySimpleType(String lexicalXSDAnySimpleType) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseAnySimpleType(lexicalXSDAnySimpleType);
    }

    public static String printString(String val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printString(val2);
    }

    public static String printInteger(BigInteger val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printInteger(val2);
    }

    public static String printInt(int val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printInt(val2);
    }

    public static String printLong(long val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printLong(val2);
    }

    public static String printShort(short val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printShort(val2);
    }

    public static String printDecimal(BigDecimal val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printDecimal(val2);
    }

    public static String printFloat(float val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printFloat(val2);
    }

    public static String printDouble(double val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printDouble(val2);
    }

    public static String printBoolean(boolean val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printBoolean(val2);
    }

    public static String printByte(byte val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printByte(val2);
    }

    public static String printQName(QName val2, NamespaceContext nsc) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printQName(val2, nsc);
    }

    public static String printDateTime(Calendar val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printDateTime(val2);
    }

    public static String printBase64Binary(byte[] val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printBase64Binary(val2);
    }

    public static String printHexBinary(byte[] val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printHexBinary(val2);
    }

    public static String printUnsignedInt(long val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printUnsignedInt(val2);
    }

    public static String printUnsignedShort(int val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printUnsignedShort(val2);
    }

    public static String printTime(Calendar val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printTime(val2);
    }

    public static String printDate(Calendar val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printDate(val2);
    }

    public static String printAnySimpleType(String val2) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printAnySimpleType(val2);
    }
}

