/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.xs.ListDV;
import org.apache.xerces.xs.ShortList;

public class EqualityHelper {
    private EqualityHelper() {
    }

    public static boolean isEqual(Object object, Object object2, short s2, short s3, ShortList shortList, ShortList shortList2, short s4) {
        if (s4 == 4) {
            return EqualityHelper.isEqual11(object, object2, s2, s3, shortList, shortList2);
        }
        return EqualityHelper.isEqual(object, object2, s2, s3, shortList, shortList2);
    }

    public static boolean isEqual(ValidatedInfo validatedInfo, ValidatedInfo validatedInfo2, short s2) {
        if (s2 == 4) {
            return EqualityHelper.isEqual11(validatedInfo.actualValue, validatedInfo2.actualValue, validatedInfo.actualValueType, validatedInfo2.actualValueType, validatedInfo.itemValueTypes, validatedInfo2.itemValueTypes);
        }
        return EqualityHelper.isEqual(validatedInfo.actualValue, validatedInfo2.actualValue, validatedInfo.actualValueType, validatedInfo2.actualValueType, validatedInfo.itemValueTypes, validatedInfo2.itemValueTypes);
    }

    private static boolean isEqual(Object object, Object object2, short s2, short s3, ShortList shortList, ShortList shortList2) {
        if (!EqualityHelper.isTypeComparable(s2, s3, shortList, shortList2)) {
            return false;
        }
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    private static boolean isTypeComparable(short s2, short s3, ShortList shortList, ShortList shortList2) {
        short s4;
        short s5 = EqualityHelper.convertToPrimitiveKind(s2);
        if (s5 == (s4 = EqualityHelper.convertToPrimitiveKind(s3))) {
            if (s5 == 44) {
                return EqualityHelper.isListTypeComparable(shortList, shortList2);
            }
            return true;
        }
        return s5 == 1 && s4 == 2 || s5 == 2 && s4 == 1;
    }

    private static boolean isEqual11(Object object, Object object2, short s2, short s3, ShortList shortList, ShortList shortList2) {
        if (!EqualityHelper.isType11Comparable(s2, s3, shortList, shortList2)) {
            return false;
        }
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof ListDV.ListData) {
            if (!(object2 instanceof ListDV.ListData)) {
                ListDV.ListData listData = (ListDV.ListData)object;
                if (listData.getLength() != 1) {
                    return false;
                }
                object = listData.get(0);
            }
        } else if (object2 instanceof ListDV.ListData) {
            ListDV.ListData listData = (ListDV.ListData)object2;
            if (listData.getLength() != 1) {
                return false;
            }
            object2 = listData.get(0);
        }
        return object.equals(object2);
    }

    private static boolean isType11Comparable(short s2, short s3, ShortList shortList, ShortList shortList2) {
        short s4;
        short s5 = EqualityHelper.convertToPrimitiveKind(s2);
        if (s5 == (s4 = EqualityHelper.convertToPrimitiveKind(s3))) {
            if (s5 == 44) {
                return EqualityHelper.isListTypeComparable(shortList, shortList2);
            }
            return true;
        }
        if (s5 == 44) {
            if (shortList == null || shortList.getLength() != 1) {
                return false;
            }
            return EqualityHelper.isType11Comparable(shortList.item(0), s4, null, null);
        }
        if (s4 == 44) {
            if (shortList2 == null || shortList2.getLength() != 1) {
                return false;
            }
            return EqualityHelper.isType11Comparable(s5, shortList2.item(0), null, null);
        }
        return s5 == 1 && s4 == 2 || s5 == 2 && s4 == 1;
    }

    private static short convertToPrimitiveKind(short s2) {
        if (s2 <= 20) {
            return s2;
        }
        if (s2 <= 29) {
            return 2;
        }
        if (s2 <= 42) {
            return 4;
        }
        if (s2 == 44 || s2 == 43) {
            return 44;
        }
        return s2;
    }

    private static boolean isListTypeComparable(ShortList shortList, ShortList shortList2) {
        int n;
        int n2 = shortList != null ? shortList.getLength() : 0;
        int n3 = n = shortList2 != null ? shortList2.getLength() : 0;
        if (n2 != n) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            short s2;
            short s3 = EqualityHelper.convertToPrimitiveKind(shortList.item(i));
            if (s3 == (s2 = EqualityHelper.convertToPrimitiveKind(shortList2.item(i))) || s3 == 1 && s2 == 2 || s3 == 2 && s2 == 1) continue;
            return false;
        }
        return true;
    }
}

