/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XS11CMRestriction;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;

class XS11Constraints
extends XSConstraints {
    public XS11Constraints() {
        super(SchemaGrammar.getXSAnyType((short)4), (short)4);
    }

    @Override
    public boolean overlapUPA(XSElementDecl xSElementDecl, XSWildcardDecl xSWildcardDecl, SubstitutionGroupHandler substitutionGroupHandler) {
        return false;
    }

    @Override
    protected final void checkElementDeclsConsistent(XSComplexTypeDecl xSComplexTypeDecl, XSParticleDecl xSParticleDecl, SymbolHash symbolHash, SubstitutionGroupHandler substitutionGroupHandler, XSGrammarBucket xSGrammarBucket, ArrayList arrayList, Stack stack) throws XMLSchemaException {
        XSTerm xSTerm;
        if (xSParticleDecl.fType == 2) {
            return;
        }
        if (arrayList.size() > 0) {
            arrayList.clear();
        }
        if (stack.size() > 0) {
            stack.clear();
        }
        if (xSComplexTypeDecl.fOpenContent != null && (xSTerm = xSComplexTypeDecl.fOpenContent.fWildcard) != null && xSTerm.fProcessContents != 2) {
            arrayList.add(xSTerm);
        }
        if (xSParticleDecl.fType == 1) {
            stack.push((XSElementDecl)xSParticleDecl.fValue);
        } else {
            this.preprocessModelGroupParticle((XSModelGroupImpl)xSParticleDecl.fValue, arrayList, stack);
        }
        while (!stack.empty()) {
            xSTerm = (XSElementDecl)stack.pop();
            this.findElemInTable(xSComplexTypeDecl, (XSElementDecl)xSTerm, symbolHash);
            if (((XSElementDecl)xSTerm).fScope == 1) {
                XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup((XSElementDecl)xSTerm, this.fSchemaVersion);
                for (int i = 0; i < xSElementDeclArray.length; ++i) {
                    this.findElemInTable(xSComplexTypeDecl, xSElementDeclArray[i], symbolHash);
                }
                continue;
            }
            this.checkExtraEDCRules(xSComplexTypeDecl, (XSElementDecl)xSTerm, xSGrammarBucket, arrayList);
        }
    }

    @Override
    public final void findElemInTable(XSComplexTypeDecl xSComplexTypeDecl, XSElementDecl xSElementDecl, SymbolHash symbolHash) throws XMLSchemaException {
        XSElementDecl xSElementDecl2 = this.findExistingElement(xSElementDecl, symbolHash);
        if (xSElementDecl2 == null || xSElementDecl2 == xSElementDecl) {
            return;
        }
        if (xSElementDecl.fType != xSElementDecl2.fType) {
            throw new XMLSchemaException("cos-element-consistent", new Object[]{xSComplexTypeDecl.fName, xSElementDecl.fName});
        }
        if (XS11TypeHelper.isTypeTablesComparable(xSElementDecl.getTypeAlternatives(), xSElementDecl2.getTypeAlternatives()) && !this.isTypeTablesEquivalent(xSElementDecl, xSElementDecl2)) {
            throw new XMLSchemaException("cos-element-consistent.4.b", new Object[]{xSComplexTypeDecl.fName, xSElementDecl.fName});
        }
    }

    protected void preprocessModelGroupParticle(XSModelGroupImpl xSModelGroupImpl, ArrayList arrayList, Stack stack) {
        for (int i = xSModelGroupImpl.fParticleCount - 1; i >= 0; --i) {
            XSParticleDecl xSParticleDecl = xSModelGroupImpl.fParticles[i];
            short s2 = xSParticleDecl.fType;
            if (s2 == 2) {
                XSWildcardDecl xSWildcardDecl = (XSWildcardDecl)xSParticleDecl.fValue;
                if (xSWildcardDecl.fProcessContents == 2) continue;
                arrayList.add(xSWildcardDecl);
                continue;
            }
            if (s2 == 1) {
                stack.push((XSElementDecl)xSParticleDecl.fValue);
                continue;
            }
            this.preprocessModelGroupParticle((XSModelGroupImpl)xSParticleDecl.fValue, arrayList, stack);
        }
    }

    private void checkExtraEDCRules(XSComplexTypeDecl xSComplexTypeDecl, XSElementDecl xSElementDecl, XSGrammarBucket xSGrammarBucket, ArrayList arrayList) throws XMLSchemaException {
        for (int i = 0; i < arrayList.size(); ++i) {
            XSElementDecl xSElementDecl2;
            SchemaGrammar schemaGrammar;
            XSWildcardDecl xSWildcardDecl = (XSWildcardDecl)arrayList.get(i);
            if (!xSWildcardDecl.allowName(xSElementDecl.fTargetNamespace, xSElementDecl.fName) || (schemaGrammar = xSGrammarBucket.getGrammar(xSElementDecl.fTargetNamespace)) == null || (xSElementDecl2 = schemaGrammar.getGlobalElementDecl(xSElementDecl.fName)) == null || xSElementDecl2 == xSElementDecl || !XS11TypeHelper.isTypeTablesComparable(xSElementDecl.getTypeAlternatives(), xSElementDecl2.getTypeAlternatives()) || this.isTypeTablesEquivalent(xSElementDecl, xSElementDecl2)) continue;
            throw new XMLSchemaException("cos-element-consistent.4.b", new Object[]{xSComplexTypeDecl.fName, xSElementDecl.fName});
        }
    }

    @Override
    public final boolean isTypeTablesEquivalent(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) {
        XSTypeAlternativeImpl[] xSTypeAlternativeImplArray;
        boolean bl = true;
        XSTypeAlternativeImpl[] xSTypeAlternativeImplArray2 = xSElementDecl.getTypeAlternatives();
        if (xSTypeAlternativeImplArray2.length != (xSTypeAlternativeImplArray = xSElementDecl2.getTypeAlternatives()).length) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < xSTypeAlternativeImplArray2.length; ++i) {
                XSTypeAlternativeImpl xSTypeAlternativeImpl = xSTypeAlternativeImplArray2[i];
                XSTypeAlternativeImpl xSTypeAlternativeImpl2 = xSTypeAlternativeImplArray[i];
                if (this.isTypeAlternativesEquivalent(xSTypeAlternativeImpl, xSTypeAlternativeImpl2)) continue;
                bl = false;
                break;
            }
        }
        if (bl && !xSElementDecl.isTypeTableOK()) {
            bl = this.isTypeAlternativesEquivalent(xSElementDecl.getDefaultTypeDefinition(), xSElementDecl2.getDefaultTypeDefinition());
        }
        return bl;
    }

    private boolean isTypeAlternativesEquivalent(XSTypeAlternativeImpl xSTypeAlternativeImpl, XSTypeAlternativeImpl xSTypeAlternativeImpl2) {
        String string = xSTypeAlternativeImpl.getXPathDefaultNamespace();
        String string2 = xSTypeAlternativeImpl2.getXPathDefaultNamespace();
        String string3 = xSTypeAlternativeImpl.getTest() == null ? null : xSTypeAlternativeImpl.getTest().toString();
        String string4 = xSTypeAlternativeImpl2.getTest() == null ? null : xSTypeAlternativeImpl2.getTest().toString();
        XSTypeDefinition xSTypeDefinition = xSTypeAlternativeImpl.getTypeDefinition();
        XSTypeDefinition xSTypeDefinition2 = xSTypeAlternativeImpl2.getTypeDefinition();
        String string5 = xSTypeAlternativeImpl.getBaseURI();
        String string6 = xSTypeAlternativeImpl2.getBaseURI();
        if (string != string2 || xSTypeDefinition != xSTypeDefinition2 || string3 == null && string4 != null || string3 != null && !string3.equals(string4) || string5 == null && string6 != null || string5 != null && !string5.equals(string6)) {
            return false;
        }
        NamespaceSupport namespaceSupport = xSTypeAlternativeImpl.getNamespaceContext();
        NamespaceSupport namespaceSupport2 = xSTypeAlternativeImpl2.getNamespaceContext();
        Enumeration enumeration = namespaceSupport.getAllPrefixes();
        Enumeration enumeration2 = namespaceSupport2.getAllPrefixes();
        while (enumeration.hasMoreElements()) {
            if (!enumeration2.hasMoreElements()) {
                return false;
            }
            String string7 = (String)enumeration.nextElement();
            String string8 = (String)enumeration2.nextElement();
            if (namespaceSupport.getURI(string7) == namespaceSupport2.getURI(string7) && namespaceSupport.getURI(string8) == namespaceSupport2.getURI(string8)) continue;
            return false;
        }
        return !enumeration2.hasMoreElements();
    }

    @Override
    public boolean isSubsetOf(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        if (xSWildcardDecl2 == null) {
            return false;
        }
        if (xSWildcardDecl2.fType != 1) {
            if (xSWildcardDecl.fType == 3) {
                if (xSWildcardDecl2.fType == 3 ? !this.subset2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList) : !this.disjoint2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList)) {
                    return false;
                }
            } else if (xSWildcardDecl.fType == 2) {
                if (xSWildcardDecl2.fType != 2 || !this.subset2sets(xSWildcardDecl2.fNamespaceList, xSWildcardDecl.fNamespaceList)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return !(xSWildcardDecl2.fDisallowedDefined && !xSWildcardDecl.fDisallowedDefined || xSWildcardDecl2.fDisallowedSibling && xSWildcardDecl.fDisallowedSibling) && (xSWildcardDecl2.fDisallowedNamesList == null || !this.allowedNames(xSWildcardDecl, xSWildcardDecl2));
    }

    @Override
    public XSWildcardDecl performUnionWith(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2, short s2) {
        if (xSWildcardDecl2 == null) {
            return null;
        }
        XSWildcardDecl xSWildcardDecl3 = new XSWildcardDecl();
        xSWildcardDecl3.fProcessContents = s2;
        if (this.areSame(xSWildcardDecl, xSWildcardDecl2)) {
            xSWildcardDecl3.fType = xSWildcardDecl.fType;
            xSWildcardDecl3.fNamespaceList = xSWildcardDecl.fNamespaceList;
        } else if (xSWildcardDecl.fType == 1 || xSWildcardDecl2.fType == 1) {
            xSWildcardDecl3.fType = 1;
        } else if (xSWildcardDecl.fType == 3 && xSWildcardDecl2.fType == 3) {
            xSWildcardDecl3.fType = (short)3;
            xSWildcardDecl3.fNamespaceList = this.union2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList);
        } else if (xSWildcardDecl.fType == 2 && xSWildcardDecl2.fType == 2) {
            String[] stringArray = this.intersect2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList);
            if (stringArray.length == 0) {
                xSWildcardDecl3.fType = 1;
            } else {
                xSWildcardDecl3.fType = (short)2;
                xSWildcardDecl3.fNamespaceList = stringArray;
            }
        } else {
            String[] stringArray;
            String[] stringArray2 = stringArray = xSWildcardDecl.fType == 2 ? this.difference2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList) : this.difference2sets(xSWildcardDecl2.fNamespaceList, xSWildcardDecl.fNamespaceList);
            if (stringArray.length == 0) {
                xSWildcardDecl3.fType = 1;
            } else {
                xSWildcardDecl3.fType = (short)2;
                xSWildcardDecl3.fNamespaceList = stringArray;
            }
        }
        xSWildcardDecl3.fDisallowedNamesList = this.disallowedNamesUnion(xSWildcardDecl, xSWildcardDecl2);
        xSWildcardDecl3.fDisallowedDefined = xSWildcardDecl.fDisallowedDefined && xSWildcardDecl2.fDisallowedDefined;
        return xSWildcardDecl3;
    }

    @Override
    public XSWildcardDecl performIntersectionWith(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2, short s2) {
        if (xSWildcardDecl2 == null) {
            return null;
        }
        XSWildcardDecl xSWildcardDecl3 = new XSWildcardDecl();
        xSWildcardDecl3.fProcessContents = s2;
        if (this.areSame(xSWildcardDecl, xSWildcardDecl2)) {
            xSWildcardDecl3.fType = xSWildcardDecl.fType;
            xSWildcardDecl3.fNamespaceList = xSWildcardDecl.fNamespaceList;
        } else if (xSWildcardDecl.fType == 1 || xSWildcardDecl2.fType == 1) {
            XSWildcardDecl xSWildcardDecl4 = xSWildcardDecl;
            if (xSWildcardDecl.fType == 1) {
                xSWildcardDecl4 = xSWildcardDecl2;
            }
            xSWildcardDecl3.fType = xSWildcardDecl4.fType;
            xSWildcardDecl3.fNamespaceList = xSWildcardDecl4.fNamespaceList;
        } else if (xSWildcardDecl.fType == 3 && xSWildcardDecl2.fType == 3) {
            xSWildcardDecl3.fType = (short)3;
            xSWildcardDecl3.fNamespaceList = this.intersect2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList);
        } else if (xSWildcardDecl.fType == 2 && xSWildcardDecl2.fType == 2) {
            xSWildcardDecl3.fType = (short)2;
            xSWildcardDecl3.fNamespaceList = this.union2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList);
        } else {
            xSWildcardDecl3.fType = (short)3;
            xSWildcardDecl3.fNamespaceList = xSWildcardDecl.fType == 2 ? this.difference2sets(xSWildcardDecl2.fNamespaceList, xSWildcardDecl.fNamespaceList) : this.difference2sets(xSWildcardDecl.fNamespaceList, xSWildcardDecl2.fNamespaceList);
        }
        xSWildcardDecl3.fDisallowedNamesList = this.disallowedNamesIntersection(xSWildcardDecl, xSWildcardDecl2);
        xSWildcardDecl3.fDisallowedDefined = xSWildcardDecl.fDisallowedDefined || xSWildcardDecl2.fDisallowedDefined;
        return xSWildcardDecl3;
    }

    @Override
    boolean areSame(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        if (xSWildcardDecl.fType == xSWildcardDecl2.fType) {
            if (xSWildcardDecl.fType == 1) {
                return true;
            }
            if (xSWildcardDecl.fNamespaceList.length == xSWildcardDecl2.fNamespaceList.length) {
                for (int i = 0; i < xSWildcardDecl.fNamespaceList.length; ++i) {
                    if (this.elementInSet(xSWildcardDecl.fNamespaceList[i], xSWildcardDecl2.fNamespaceList)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean allowedNames(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        for (int i = 0; i < xSWildcardDecl2.fDisallowedNamesList.length; ++i) {
            if (!xSWildcardDecl.allowQName(xSWildcardDecl2.fDisallowedNamesList[i])) continue;
            return true;
        }
        return false;
    }

    private boolean disallowedNamespaces(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        if (xSWildcardDecl2.fType == 1) {
            return false;
        }
        if (xSWildcardDecl.fType == 1) {
            return true;
        }
        if (xSWildcardDecl.fType == 3) {
            for (int i = 0; i < xSWildcardDecl.fNamespaceList.length; ++i) {
                if (xSWildcardDecl2.allowNamespace(xSWildcardDecl.fNamespaceList[i])) continue;
                return true;
            }
            return false;
        }
        if (xSWildcardDecl2.fType == 2) {
            for (int i = 0; i < xSWildcardDecl2.fNamespaceList.length; ++i) {
                if (!xSWildcardDecl.allowNamespace(xSWildcardDecl2.fNamespaceList[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String[] difference2sets(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.elementInSet(stringArray[i], stringArray2)) continue;
            stringArray3[n++] = stringArray[i];
        }
        String[] stringArray4 = new String[n];
        System.arraycopy(stringArray3, 0, stringArray4, 0, n);
        return stringArray4;
    }

    private QName[] disallowedNamesUnion(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        int n;
        int n2 = xSWildcardDecl.fDisallowedNamesList == null ? 0 : xSWildcardDecl.fDisallowedNamesList.length;
        int n3 = xSWildcardDecl2.fDisallowedNamesList == null ? 0 : xSWildcardDecl2.fDisallowedNamesList.length;
        QName[] qNameArray = new QName[n2 + n3];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (xSWildcardDecl2.allowQName(xSWildcardDecl.fDisallowedNamesList[n])) continue;
            qNameArray[n4++] = xSWildcardDecl.fDisallowedNamesList[n];
        }
        for (n = 0; n < n3; ++n) {
            if (xSWildcardDecl.allowQName(xSWildcardDecl2.fDisallowedNamesList[n])) continue;
            qNameArray[n4++] = xSWildcardDecl2.fDisallowedNamesList[n];
        }
        QName[] qNameArray2 = new QName[n4];
        System.arraycopy(qNameArray, 0, qNameArray2, 0, n4);
        return qNameArray2;
    }

    private QName[] disallowedNamesIntersection(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        int n;
        int n2 = xSWildcardDecl.fDisallowedNamesList == null ? 0 : xSWildcardDecl.fDisallowedNamesList.length;
        int n3 = xSWildcardDecl2.fDisallowedNamesList == null ? 0 : xSWildcardDecl2.fDisallowedNamesList.length;
        QName[] qNameArray = new QName[n2 + n3];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            QName qName = xSWildcardDecl.fDisallowedNamesList[n];
            if (xSWildcardDecl2.allowQName(qName)) {
                qNameArray[n4++] = qName;
                continue;
            }
            if (!this.elementInSet(qName, xSWildcardDecl2.fDisallowedNamesList)) continue;
            qNameArray[n4++] = qName;
        }
        for (n = 0; n < n3; ++n) {
            if (!xSWildcardDecl.allowQName(xSWildcardDecl2.fDisallowedNamesList[n])) continue;
            qNameArray[n4++] = xSWildcardDecl2.fDisallowedNamesList[n];
        }
        QName[] qNameArray2 = new QName[n4];
        System.arraycopy(qNameArray, 0, qNameArray2, 0, n4);
        return qNameArray2;
    }

    private boolean elementInSet(QName qName, QName[] qNameArray) {
        boolean bl = false;
        int n = qNameArray == null ? 0 : qNameArray.length;
        for (int i = 0; i < n && !bl; ++i) {
            if (!qName.equals(qNameArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    protected void groupSubsumption(XSParticleDecl xSParticleDecl, XSParticleDecl xSParticleDecl2, XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder, XMLErrorReporter xMLErrorReporter, String string, SimpleLocator simpleLocator) {
        XSCMValidator xSCMValidator = cMBuilder.getContentModel(xSParticleDecl);
        XSCMValidator xSCMValidator2 = cMBuilder.getContentModel(xSParticleDecl2);
        if (!new XS11CMRestriction(xSCMValidator2, xSCMValidator, substitutionGroupHandler, xSGrammarBucket, cMBuilder, this).check()) {
            this.reportSchemaError(xMLErrorReporter, simpleLocator, "src-redefine.6.2.2", new Object[]{string, ""});
        }
    }

    @Override
    protected void typeSubsumption(XSComplexTypeDecl xSComplexTypeDecl, XSComplexTypeDecl xSComplexTypeDecl2, XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder, XMLErrorReporter xMLErrorReporter, SimpleLocator simpleLocator) {
        XSCMValidator xSCMValidator = xSComplexTypeDecl.getContentModel(cMBuilder);
        XSCMValidator xSCMValidator2 = xSComplexTypeDecl2.getContentModel(cMBuilder);
        if (!new XS11CMRestriction(xSCMValidator2, xSCMValidator, substitutionGroupHandler, xSGrammarBucket, cMBuilder, this).check()) {
            this.reportSchemaError(xMLErrorReporter, simpleLocator, "derivation-ok-restriction.5.4.2", new Object[]{xSComplexTypeDecl.fName});
        }
    }

    @Override
    protected final boolean checkEmptyFacets(XSSimpleType xSSimpleType) {
        return xSSimpleType.getMultiValueFacets() == XSObjectListImpl.EMPTY_LIST;
    }
}

