/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.TypeValidatorHelper;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;

public class XS11TypeHelper {
    private XS11TypeHelper() {
    }

    public static boolean isSchemaTypesIdentical(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2) {
        boolean bl = false;
        String string = xSTypeDefinition.getName();
        String string2 = xSTypeDefinition2.getName();
        if ("anyType".equals(string) && "anyType".equals(string2) || "anySimpleType".equals(string) && "anySimpleType".equals(string2)) {
            bl = true;
        }
        if (!bl && XS11TypeHelper.isURIEqual(xSTypeDefinition.getNamespace(), xSTypeDefinition2.getNamespace()) && (string == null && string2 == null || string != null && string.equals(string2) && XS11TypeHelper.isSchemaTypesIdentical(xSTypeDefinition.getBaseType(), xSTypeDefinition2.getBaseType()))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isURIEqual(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    public static boolean isAtomicStrValueValidForSTUnion(XSObjectList xSObjectList, String string, ValidatedInfo validatedInfo, short s2) {
        boolean bl = false;
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            XSSimpleType xSSimpleType = (XSSimpleType)xSObjectList.item(i);
            if (!SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(xSSimpleType.getNamespace()) || !XS11TypeHelper.isStrValueValidForASimpleType(string, xSSimpleType, s2)) continue;
            bl = true;
            validatedInfo.memberType = xSSimpleType;
            break;
        }
        return bl;
    }

    public static boolean isStrValueValidForASimpleType(String string, XSSimpleType xSSimpleType, short s2) {
        boolean bl = true;
        try {
            ValidatedInfo validatedInfo = new ValidatedInfo();
            ValidationState validationState = new ValidationState();
            validationState.setTypeValidatorHelper(TypeValidatorHelper.getInstance(s2));
            xSSimpleType.validate(string, (ValidationContext)validationState, validatedInfo);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            bl = false;
        }
        return bl;
    }

    public static void validateQNameValue(String string, NamespaceContext namespaceContext, XMLErrorReporter xMLErrorReporter) {
        String[] stringArray = XS11TypeHelper.parseQnameString(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (string2.length() > 0 && !XMLChar.isValidNCName(string2) || !XMLChar.isValidNCName(string3)) {
            xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "cvc-datatype-valid.1.2.1", new Object[]{string, "QName"}, (short)1);
        }
        String string4 = namespaceContext.getURI(string2.intern());
        if (string2.length() > 0 && string4 == null) {
            xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "UndeclaredPrefix", new Object[]{string, string2}, (short)1);
        }
    }

    private static String[] parseQnameString(String string) {
        String string2;
        String string3;
        String[] stringArray = new String[2];
        int n = string.indexOf(58);
        if (n > 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = SchemaSymbols.EMPTY_STRING;
            string2 = string;
        }
        stringArray[0] = string3;
        stringArray[1] = string2;
        return stringArray;
    }

    public static Vector getAssertsFromSimpleType(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        Vector vector = new Vector();
        XSObjectListImpl xSObjectListImpl = (XSObjectListImpl)xSSimpleTypeDefinition.getMultiValueFacets();
        for (int i = 0; i < xSObjectListImpl.getLength(); ++i) {
            XSMultiValueFacet xSMultiValueFacet = (XSMultiValueFacet)xSObjectListImpl.item(i);
            if (xSMultiValueFacet.getFacetKind() != 16384) continue;
            vector = xSMultiValueFacet.getAsserts();
        }
        return vector;
    }

    public static boolean simpleTypeHasAsserts(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        boolean bl = false;
        XSObjectList xSObjectList = xSSimpleTypeDefinition.getMultiValueFacets();
        int n = xSObjectList.getLength();
        for (int i = 0; i < n; ++i) {
            XSMultiValueFacet xSMultiValueFacet = (XSMultiValueFacet)xSObjectList.item(i);
            if (xSMultiValueFacet.getFacetKind() != 16384 || xSMultiValueFacet.getAsserts().size() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isListContainsType(List list, XSTypeDefinition xSTypeDefinition) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!XS11TypeHelper.isSchemaTypesIdentical((XSTypeDefinition)iterator.next(), xSTypeDefinition)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isComplexTypeDerivedFromSTList(XSComplexTypeDefinition xSComplexTypeDefinition, short s2) {
        XSTypeDefinition xSTypeDefinition = xSComplexTypeDefinition.getBaseType();
        return xSComplexTypeDefinition.getDerivationMethod() == s2 && xSTypeDefinition instanceof XSSimpleTypeDefinition && ((XSSimpleTypeDefinition)xSTypeDefinition).getVariety() == 2;
    }

    public static String getSchemaTypeName(XSTypeDefinition xSTypeDefinition) {
        String string = "";
        string = xSTypeDefinition instanceof XSSimpleTypeDefinition ? ((XSSimpleTypeDecl)xSTypeDefinition).getTypeName() : ((XSComplexTypeDecl)xSTypeDefinition).getTypeName();
        return string;
    }

    public static boolean isSpecialSimpleType(XSSimpleType xSSimpleType) {
        boolean bl = false;
        String string = xSSimpleType.getName();
        if (Constants.NS_XMLSCHEMA.equals(xSSimpleType.getNamespace()) && ("anyAtomicType".equals(string) || "anySimpleType".equals(string))) {
            bl = true;
        }
        return bl;
    }

    public static ResultSequence getXPath2ResultSequence(List list) {
        ResultSequence resultSequence = ResultSequenceFactory.create_new();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            resultSequence.add((AnyType)iterator.next());
        }
        return resultSequence;
    }

    public static boolean isTypeTablesComparable(XSTypeAlternativeImpl[] xSTypeAlternativeImplArray, XSTypeAlternativeImpl[] xSTypeAlternativeImplArray2) {
        boolean bl = true;
        if (xSTypeAlternativeImplArray == null && xSTypeAlternativeImplArray2 == null) {
            bl = false;
        }
        return bl;
    }
}

